/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors.scope;

import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.structure.DecoratableObject;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.visitors.NodeUtils;

public class ASTEntry
extends DecoratableObject {
    public ASTEntry parent;
    public SimpleNode node;
    public int endLine;
    private String name;
    public int endCol;

    public ASTEntry(ASTEntry parent, SimpleNode node) {
        this(parent);
        this.node = node;
        if (node != null) {
            this.endLine = node.beginLine;
        }
    }

    public ASTEntry(ASTEntry parent) {
        this.parent = parent;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.node instanceof ClassDef) {
            this.name = NodeUtils.getNameFromNameTok((NameTok)((ClassDef)this.node).name);
        } else if (this.node instanceof FunctionDef) {
            this.name = NodeUtils.getNameFromNameTok((NameTok)((FunctionDef)this.node).name);
        } else if (this.node instanceof Import) {
            aliasType[] names = ((Import)this.node).names;
            StringBuffer buffer = new StringBuffer("import ");
            int i = 0;
            while (i < names.length) {
                buffer.append(((NameTok)names[i].name).id);
                if (names[i].asname != null) {
                    buffer.append(" as ");
                    buffer.append(((NameTok)names[i].asname).id);
                }
                ++i;
            }
            this.name = buffer.toString();
        } else if (this.node instanceof ImportFrom) {
            aliasType[] names = ((ImportFrom)this.node).names;
            StringBuffer buffer = new StringBuffer("from ");
            buffer.append(((NameTok)((ImportFrom)this.node).module).id);
            buffer.append(" import ");
            if (names.length > 0) {
                int i = 0;
                while (i < names.length) {
                    buffer.append(((NameTok)names[i].name).id);
                    if (names[i].asname != null) {
                        buffer.append(" as ");
                        buffer.append(((NameTok)names[i].asname).id);
                    }
                    ++i;
                }
            } else {
                buffer.append("*");
            }
            this.name = buffer.toString();
        } else if (this.node instanceof Attribute) {
            Attribute a = (Attribute)this.node;
            this.name = ((NameTok)a.attr).id;
        } else if (this.node instanceof Name) {
            Name a = (Name)this.node;
            this.name = a.id;
        } else if (this.node instanceof NameTok) {
            NameTok a = (NameTok)this.node;
            this.name = a.id;
        } else if (this.node instanceof Module) {
            this.name = "Module";
        } else if (this.node instanceof Str) {
            this.name = "Str";
        } else if (this.node instanceof While) {
            this.name = "While";
        } else if (this.node instanceof If) {
            this.name = "If";
        } else if (this.node instanceof For) {
            this.name = "For";
        } else if (this.node instanceof TryExcept) {
            this.name = "TryExcept";
        } else if (this.node instanceof TryFinally) {
            this.name = "TryFinally";
        } else if (this.node instanceof With) {
            this.name = "With";
        } else if (this.node instanceof commentType) {
            this.name = "comment";
        }
        if (this.name == null) {
            throw new RuntimeException("Unable to get node name: " + this.node);
        }
        return this.name;
    }

    public SimpleNode getNameNode() {
        if (this.node instanceof ClassDef) {
            return ((ClassDef)this.node).name;
        }
        if (this.node instanceof FunctionDef) {
            return ((FunctionDef)this.node).name;
        }
        return this.node;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AstEntry<");
        buffer.append(this.getName());
        buffer.append(" (");
        buffer.append(FullRepIterable.getLastPart((String)this.node.getClass().getName()));
        buffer.append(" L=");
        buffer.append(this.node.beginLine);
        buffer.append(" C=");
        buffer.append(this.node.beginColumn);
        buffer.append(")");
        buffer.append(">");
        return buffer.toString();
    }

    public int hashCode() {
        int i = 31;
        String n = this.getName();
        if (n != null) {
            i *= n.hashCode();
        }
        i += this.node.beginLine;
        return i *= this.node.beginColumn;
    }

    public boolean equals(Object obj) {
        String oN;
        if (!(obj instanceof ASTEntry)) {
            return false;
        }
        ASTEntry other = (ASTEntry)((Object)obj);
        if (this.node.beginColumn != other.node.beginColumn || this.node.beginLine != other.node.beginLine || this.endCol != other.endCol || this.endLine != other.endLine) {
            return false;
        }
        String n = this.getName();
        return n.equals(oN = other.getName());
    }
}

