AR = '/usr/bin/ar'
ARFLAGS = 'rcs'
CCFLAGS = ['-g', '-O3', '-Wall', '-D_FILE_OFFSET_BITS=64', '-D_LARGEFILE_SOURCE']
CCFLAGS_CAIRO = ['-pthread']
CCFLAGS_MACBUNDLE = ['-fPIC']
CCFLAGS_NODE = ['-D_LARGEFILE_SOURCE', '-D_FILE_OFFSET_BITS=64']
CC_VERSION = ('4', '2', '1')
COMPILER_CXX = 'g++'
CPP = '/usr/bin/cpp'
CPPFLAGS = ['-DNDEBUG', '-DHAVE_GIF=1', '-DHAVE_JPEG=1']
CPPFLAGS_NODE = ['-D_GNU_SOURCE']
CPPPATH_CAIRO = ['/usr/local/include/cairo', '/usr/local/include/glib-2.0', '/usr/local/lib/glib-2.0/include', '/usr/local/include', '/usr/X11R6/include/pixman-1', '/usr/X11R6/include', '/usr/X11R6/include/freetype2', '/usr/include/dev/pci/drm', '/usr/local/include/libpng']
CPPPATH_NODE = '/usr/local/include/node'
CPPPATH_ST = '-I%s'
CXX = ['/usr/bin/g++']
CXXDEFINES_ST = '-D%s'
CXXFLAGS = ['-g', '-O3', '-Wall', '-D_FILE_OFFSET_BITS=64', '-D_LARGEFILE_SOURCE']
CXXFLAGS_CAIRO = ['-pthread']
CXXFLAGS_DEBUG = ['-g']
CXXFLAGS_NODE = ['-D_LARGEFILE_SOURCE', '-D_FILE_OFFSET_BITS=64']
CXXFLAGS_RELEASE = ['-O2']
CXXLNK_SRC_F = ''
CXXLNK_TGT_F = ['-o', '']
CXX_NAME = 'gcc'
CXX_SRC_F = ''
CXX_TGT_F = ['-c', '-o', '']
DEST_BINFMT = 'elf'
DEST_CPU = 'x86'
DEST_OS = 'openbsd'
FULLSTATIC_MARKER = '-static'
HAVE_CAIRO = 1
LIBDIR = '/usr/obj/node-canvas-0.12.0/.node_libraries'
LIBPATH_CAIRO = ['/usr/local/lib', '/usr/X11R6/lib']
LIBPATH_GIF = ['/lib', '/usr/lib', '/usr/local/lib', '/opt/local/lib']
LIBPATH_JPEG = ['/lib', '/usr/lib', '/usr/local/lib', '/opt/local/lib']
LIBPATH_NODE = '/usr/local/lib'
LIBPATH_ST = '-L%s'
LIB_CAIRO = ['cairo', 'gobject-2.0', 'glib-2.0', 'intl', 'iconv', 'pcre', 'pixman-1', 'fontconfig', 'expat', 'freetype', 'GL', 'drm', 'Xdamage', 'Xfixes', 'Xxf86vm', 'Xext', 'png', 'z', 'm', 'xcb-shm', 'xcb-render', 'Xrender', 'X11', 'xcb', 'pthread-stubs', 'Xau', 'Xdmcp']
LIB_GIF = ['gif']
LIB_JPEG = ['jpeg']
LIB_ST = '-l%s'
LINKFLAGS_CAIRO = ['-pthread']
LINKFLAGS_MACBUNDLE = ['-bundle', '-undefined', 'dynamic_lookup']
LINK_CXX = ['/usr/bin/g++']
NODE_PATH = '/usr/obj/node-canvas-0.12.0/.node_libraries'
PREFIX = '/usr/local'
PREFIX_NODE = '/usr/local'
RANLIB = '/usr/bin/ranlib'
RPATH_ST = '-Wl,-rpath,%s'
SHLIB_MARKER = '-Wl,-Bdynamic'
SONAME_ST = '-Wl,-h,%s'
STATICLIBPATH_ST = '-L%s'
STATICLIB_MARKER = '-Wl,-Bstatic'
STATICLIB_ST = '-l%s'
USE_PROFILING = False
defines = {'HAVE_CAIRO': 1}
macbundle_PATTERN = '%s.bundle'
program_PATTERN = '%s'
shlib_CXXFLAGS = ['-fPIC', '-DPIC']
shlib_LINKFLAGS = ['-shared']
shlib_PATTERN = 'lib%s.so'
staticlib_LINKFLAGS = ['-Wl,-Bstatic']
staticlib_PATTERN = 'lib%s.a'
