# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.range import Range

import pgm
import gobject

import logging


class Slider(Range):
    """A Range widget that expands and shrinks the size of its cursor"""

    def __init__(self):
        super(Slider, self).__init__()

    def do_index_changed(self, current, previous):
        """
        Overrided 'index-changed' signal handler: change the size of the
        cursor, not the position
        """
        if 0 <= current < self.items_number:
            self._update_cursor_size()

    def _update_cursor_position(self):
        pass

    @classmethod
    def _demo_widget(cls, *args, **kwargs):
        widget = cls()
        widget.size = (100.0, 100.0)
        widget.items_number = 12
        widget.visible = True

        return widget


if __name__ == "__main__":
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    slider = Slider.demo ()
    try:
        __IPYTHON__
    except NameError:
        pgm.main()

