/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;

public class TraceType {
    private final Gather gather;
    private final Format format;
    private static final String FIRST_COLOR = "\u001b[0;31m";
    private static final String KERNEL_COLOR = "\u001b[0;36m";
    private static final String EVAL_COLOR = "\u001b[0;33m";
    private static final String CLEAR_COLOR = "\u001b[0m";

    public TraceType(Gather gather, Format format) {
        this.gather = gather;
        this.format = format;
    }

    public BacktraceData getBacktrace(ThreadContext context, boolean nativeException) {
        return this.gather.getBacktraceData(context, nativeException);
    }

    public String printBacktrace(RubyException exception2) {
        return this.format.printBacktrace(exception2);
    }

    public static void dumpException(RubyException exception2) {
        System.err.println("Exception raised: " + exception2.getMetaClass() + ": " + exception2);
    }

    public static void dumpBacktrace(RubyException exception2) {
        System.err.println("Backtrace generated:\n" + Format.JRUBY.printBacktrace(exception2));
    }

    public static void dumpCaller(RubyArray trace) {
        System.err.println("Caller backtrace generated:\n" + trace);
    }

    public static TraceType traceTypeFor(String style) {
        if (style.equalsIgnoreCase("raw")) {
            return new TraceType(Gather.RAW, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("ruby_framed")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("rubinius")) {
            return new TraceType(Gather.NORMAL, Format.RUBINIUS);
        }
        if (style.equalsIgnoreCase("full")) {
            return new TraceType(Gather.FULL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("mri")) {
            return new TraceType(Gather.NORMAL, Format.MRI);
        }
        return new TraceType(Gather.NORMAL, Format.JRUBY);
    }

    protected static String printBacktraceMRI(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject backtrace2 = exception2.callMethod(context, "backtrace");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = new PrintStream(baos);
        boolean printedPosition = false;
        if (backtrace2.isNil() || !(backtrace2 instanceof RubyArray)) {
            if (context.getFile() != null && context.getFile().length() > 0) {
                errorStream.print(context.getFile() + ":" + context.getLine());
                printedPosition = true;
            } else {
                errorStream.print(context.getLine());
                printedPosition = true;
            }
        } else if (((RubyArray)backtrace2).getLength() == 0) {
            TraceType.printErrorPos(context, errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace2).first();
            if (mesg.isNil()) {
                TraceType.printErrorPos(context, errorStream);
            } else {
                errorStream.print(mesg);
                printedPosition = true;
            }
        }
        RubyClass type2 = exception2.getMetaClass();
        String info = exception2.toString();
        if (printedPosition) {
            errorStream.print(": ");
        }
        if (type2 == runtime2.getRuntimeError() && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            String path2 = type2.getName();
            if (info.length() == 0) {
                errorStream.print(path2 + '\n');
            } else {
                if (path2.startsWith("#")) {
                    path2 = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                errorStream.print(info);
                if (path2 != null) {
                    errorStream.print(" (" + path2 + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        exception2.printBacktrace(errorStream);
        return new String(baos.toByteArray());
    }

    protected static String printBacktraceRubinius(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        RubyStackTraceElement[] frames = exception2.getBacktraceElements();
        if (frames == null) {
            frames = new RubyStackTraceElement[]{};
        }
        ArrayList<String> firstParts = new ArrayList<String>();
        int longestFirstPart = 0;
        for (RubyStackTraceElement frame : frames) {
            String firstPart = frame.getClassName() + "#" + frame.getMethodName();
            if (firstPart.length() > longestFirstPart) {
                longestFirstPart = firstPart.length();
            }
            firstParts.add(firstPart);
        }
        int center2 = longestFirstPart + 2 + 1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("An exception has occurred:\n").append("    ");
        if (exception2.getMetaClass() == runtime2.getRuntimeError() && exception2.message(runtime2.getCurrentContext()).toString().length() == 0) {
            buffer.append("No current exception (RuntimeError)");
        } else {
            buffer.append(exception2.message(runtime2.getCurrentContext()).toString());
        }
        buffer.append('\n').append('\n').append("Backtrace:\n");
        int i2 = 0;
        for (RubyStackTraceElement frame : frames) {
            String firstPart = (String)firstParts.get(i2);
            String secondPart = frame.getFileName() + ":" + frame.getLineNumber();
            if (i2 == 0) {
                buffer.append(FIRST_COLOR);
            } else if (frame.isBinding() || frame.getFileName().equals("(eval)")) {
                buffer.append(EVAL_COLOR);
            } else if (frame.getFileName().indexOf(".java") != -1) {
                buffer.append(KERNEL_COLOR);
            }
            buffer.append("  ");
            for (int j = 0; j < center2 - firstPart.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(firstPart);
            buffer.append(" at ");
            buffer.append(secondPart);
            buffer.append(CLEAR_COLOR);
            buffer.append('\n');
            ++i2;
        }
        return buffer.toString();
    }

    protected static String printBacktraceJRuby(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        RubyStackTraceElement[] frames = exception2.getBacktraceElements();
        if (frames == null) {
            frames = new RubyStackTraceElement[]{};
        }
        int longestMethod = 0;
        for (RubyStackTraceElement frame : frames) {
            longestMethod = Math.max(longestMethod, frame.getMethodName().length());
        }
        StringBuilder buffer = new StringBuilder();
        String message2 = exception2.message(runtime2.getCurrentContext()).toString();
        if (exception2.getMetaClass() == runtime2.getRuntimeError() && message2.length() == 0) {
            message2 = "No current exception";
        }
        buffer.append(exception2.getMetaClass().getName()).append(": ").append(message2).append('\n');
        for (RubyStackTraceElement frame : frames) {
            buffer.append("  ");
            String methodName = frame.getMethodName();
            for (int j = 0; j < longestMethod - methodName.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(methodName).append(" at ").append(frame.getFileName()).append(':').append(frame.getLineNumber()).append('\n');
        }
        return buffer.toString();
    }

    protected static String printBacktraceJRuby2(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        RubyStackTraceElement[] frames = exception2.getBacktraceData().getBacktrace(runtime2);
        if (frames == null) {
            frames = new RubyStackTraceElement[]{};
        }
        ArrayList<String> lineNumbers = new ArrayList<String>(frames.length);
        int longestFileName = 0;
        int longestLineNumber = 0;
        for (RubyStackTraceElement frame : frames) {
            String lineNumber = String.valueOf(frame.getLineNumber());
            lineNumbers.add(lineNumber);
            longestFileName = Math.max(longestFileName, frame.getFileName().length());
            longestLineNumber = Math.max(longestLineNumber, String.valueOf(frame.getLineNumber()).length());
        }
        StringBuilder buffer = new StringBuilder();
        String message2 = exception2.message(runtime2.getCurrentContext()).toString();
        if (exception2.getMetaClass() == runtime2.getRuntimeError() && message2.length() == 0) {
            message2 = "No current exception";
        }
        buffer.append(exception2.getMetaClass().getName()).append(": ").append(message2).append('\n');
        int i2 = 0;
        for (RubyStackTraceElement frame : frames) {
            buffer.append("  ");
            String fileName = frame.getFileName();
            String lineNumber = (String)lineNumbers.get(i2);
            for (int j = 0; j < longestFileName - fileName.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(fileName).append(":").append(lineNumber);
            for (int l = 0; l < longestLineNumber - lineNumber.length(); ++l) {
                buffer.append(' ');
            }
            buffer.append(' ').append("in ").append(frame.getMethodName()).append('\n');
            ++i2;
        }
        return buffer.toString();
    }

    public static IRubyObject generateMRIBacktrace(Ruby runtime2, RubyStackTraceElement[] trace) {
        if (trace == null) {
            return runtime2.getNil();
        }
        RubyArray traceArray = RubyArray.newArray(runtime2);
        for (int i2 = 0; i2 < trace.length; ++i2) {
            RubyStackTraceElement element = trace[i2];
            RubyString str = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'");
            traceArray.append(str);
        }
        return traceArray;
    }

    protected static BacktraceData getBacktrace(ThreadContext context, Gather gather, boolean nativeException, boolean full, boolean maskNative) {
        return new BacktraceData(Thread.currentThread().getStackTrace(), context.createBacktrace2(0, nativeException), full, maskNative, gather);
    }

    private static void printErrorPos(ThreadContext context, PrintStream errorStream) {
        if (context.getFile() != null && context.getFile().length() > 0) {
            if (context.getFrameName() != null) {
                errorStream.print(context.getFile() + ":" + context.getLine());
                errorStream.print(":in '" + context.getFrameName() + '\'');
            } else if (context.getLine() != 0) {
                errorStream.print(context.getFile() + ":" + context.getLine());
            } else {
                errorStream.print(context.getFile());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        MRI{

            public String printBacktrace(RubyException exception2) {
                return TraceType.printBacktraceMRI(exception2);
            }
        }
        ,
        JRUBY{

            public String printBacktrace(RubyException exception2) {
                return TraceType.printBacktraceJRuby(exception2);
            }
        }
        ,
        RUBINIUS{

            public String printBacktrace(RubyException exception2) {
                return TraceType.printBacktraceRubinius(exception2);
            }
        };


        public abstract String printBacktrace(RubyException var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Gather {
        RAW{

            public BacktraceData getBacktraceData(ThreadContext context, Thread thread, boolean nativeException) {
                return new BacktraceData(thread.getStackTrace(), new BacktraceElement[0], true, false, this);
            }
        }
        ,
        FULL{

            public BacktraceData getBacktraceData(ThreadContext context, Thread thread, boolean nativeException) {
                return new BacktraceData(thread.getStackTrace(), context.createBacktrace2(0, nativeException), true, false, this);
            }
        }
        ,
        NORMAL{

            public BacktraceData getBacktraceData(ThreadContext context, Thread thread, boolean nativeException) {
                return new BacktraceData(thread.getStackTrace(), context.createBacktrace2(0, nativeException), false, context.runtime.getInstanceConfig().getBacktraceMask(), this);
            }
        }
        ,
        CALLER{

            public BacktraceData getBacktraceData(ThreadContext context, Thread thread, boolean nativeException) {
                return new BacktraceData(thread.getStackTrace(), context.createBacktrace2(0, nativeException), false, true, this);
            }
        };


        public BacktraceData getBacktraceData(ThreadContext context, boolean nativeException) {
            return this.getBacktraceData(context, Thread.currentThread(), nativeException);
        }

        public abstract BacktraceData getBacktraceData(ThreadContext var1, Thread var2, boolean var3);
    }
}

