/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean handlingInProgress = false;

    public void uncaughtException(Thread t, Throwable e) {
        BugReportExceptionHandler.handleException(e);
    }

    public void handle(Throwable t) {
        BugReportExceptionHandler.handleException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(Throwable e) {
        block15: {
            if (handlingInProgress) {
                return;
            }
            handlingInProgress = true;
            try {
                e.printStackTrace();
                if (Main.parent == null) break block15;
                if (e instanceof OutOfMemoryError) {
                    JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
                    return;
                }
                PluginHandler.disablePluginAfterException(e);
                Object[] options = new String[]{I18n.tr("Do nothing"), I18n.tr("Report Bug")};
                int answer = JOptionPane.showOptionDialog(Main.parent, "<html>" + I18n.tr("An unexpected exception occurred.<br>This is always a coding error. If you are running the latest<br>version of JOSM, please consider being kind and file a bug report.") + "</html>", I18n.tr("Unexpected Exception"), 0, 0, null, options, options[0]);
                if (answer != 1) {
                    return;
                }
                try {
                    int maxlen = 7000;
                    StringWriter stack = new StringWriter();
                    e.printStackTrace(new PrintWriter(stack));
                    String text = ShowStatusReportAction.getReportHeader() + stack.getBuffer().toString();
                    String urltext = text.replaceAll("\r", "");
                    if (urltext.length() > 7000) {
                        int idx = (urltext = urltext.substring(0, 7000)).lastIndexOf("\n");
                        if (7000 - idx < 200) {
                            urltext = urltext.substring(0, idx + 1);
                        }
                        urltext = urltext + "...<snip>...\n";
                    }
                    URL url = new URL("http://josm.openstreetmap.de/josmticket?data=" + Base64.encode("keywords=template_report&description=" + URLEncoder.encode("What steps will reproduce the problem?\n 1. \n 2. \n 3. \n\nWhat is the expected result?\n\nWhat happens instead?\n\nPlease provide any additional information below. Attach a screenshot if\npossible.\n\n{{{\n" + urltext + "\n}}}\n", "UTF-8")));
                    JPanel p = new JPanel(new GridBagLayout());
                    p.add((Component)new JMultilineLabel(I18n.tr("You have encountered an error in JOSM. Before you file a bug report make sure you have updated to the latest version of JOSM here:")), GBC.eol());
                    p.add((Component)new UrlLabel("http://josm.openstreetmap.de/#Download"), GBC.eop().insets(8, 0, 0, 0));
                    p.add((Component)new JMultilineLabel(I18n.tr("You should also update your plugins. If neither of those help please file a bug report in our bugtracker using this link:")), GBC.eol());
                    p.add((Component)new UrlLabel(url.toString(), "http://josm.openstreetmap.de/josmticket?..."), GBC.eop().insets(8, 0, 0, 0));
                    p.add((Component)new JMultilineLabel(I18n.tr("There the error information provided below should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.")), GBC.eop());
                    p.add((Component)new JMultilineLabel(I18n.tr("Alternatively, if that does not work you can manually fill in the information below at this URL:")), GBC.eol());
                    p.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eop().insets(8, 0, 0, 0));
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), new ClipboardOwner(){

                            public void lostOwnership(Clipboard clipboard, Transferable contents) {
                            }
                        });
                        p.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)")), GBC.eop());
                    }
                    catch (RuntimeException x) {
                        // empty catch block
                    }
                    JTextArea info = new JTextArea(text, 20, 60);
                    info.setCaretPosition(0);
                    info.setEditable(false);
                    p.add((Component)new JScrollPane(info), GBC.eop());
                    for (Component c : p.getComponents()) {
                        if (!(c instanceof JMultilineLabel)) continue;
                        ((JMultilineLabel)c).setMaxWidth(400);
                    }
                    JOptionPane.showMessageDialog(Main.parent, p, I18n.tr("You have encountered a bug in JOSM"), 0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                handlingInProgress = false;
            }
        }
    }

    public static boolean exceptionHandlingInProgress() {
        return handlingInProgress;
    }
}

