/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.PluginInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plugin {
    private PluginInformation info = null;

    public Plugin(PluginInformation info) {
        this.info = info;
    }

    public PluginInformation getPluginInformation() {
        return this.info;
    }

    public void setPluginInformation(PluginInformation info) {
        this.info = info;
    }

    public String getPluginDir() {
        return new File(Main.pref.getPluginsDirectory(), this.info.name).getPath();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
    }

    public PreferenceSetting getPreferenceSetting() {
        return null;
    }

    public void addDownloadSelection(List<DownloadSelection> list) {
    }

    public void copy(String from, String to) throws FileNotFoundException, IOException {
        String pluginDirName = this.getPluginDir();
        File pluginDir = new File(pluginDirName);
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(new File(pluginDirName, to));
        InputStream in = this.getClass().getResourceAsStream(from);
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }
}

