/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OsmDataParsingException
extends SAXException {
    private int columnNumber;
    private int lineNumber;

    public OsmDataParsingException() {
    }

    public OsmDataParsingException(Exception e) {
        super(e);
    }

    public OsmDataParsingException(String message, Exception e) {
        super(message, e);
    }

    public OsmDataParsingException(String message) {
        super(message);
    }

    public OsmDataParsingException rememberLocation(Locator locator) {
        if (locator == null) {
            return this;
        }
        this.columnNumber = locator.getColumnNumber();
        this.lineNumber = locator.getLineNumber();
        return this;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (this.lineNumber == 0 && this.columnNumber == 0) {
            return msg;
        }
        if (msg == null) {
            msg = this.getClass().getName();
        }
        msg = msg + " " + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
        return msg;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

