/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class MirroredInputStream
extends InputStream {
    InputStream fs = null;
    File file = null;

    public MirroredInputStream(String name) throws IOException {
        this(name, null, -1L);
    }

    public MirroredInputStream(String name, long maxTime) throws IOException {
        this(name, null, maxTime);
    }

    public MirroredInputStream(String name, String destDir) throws IOException {
        this(name, destDir, -1L);
    }

    public MirroredInputStream(String name, String destDir, long maxTime) throws IOException {
        try {
            URL url = new URL(name);
            if (url.getProtocol().equals("file")) {
                this.file = new File(name.substring("file:/".length()));
                if (!this.file.exists()) {
                    this.file = new File(name.substring("file://".length()));
                }
            } else {
                this.file = this.checkLocal(url, destDir, maxTime);
            }
        }
        catch (MalformedURLException e) {
            if (name.startsWith("resource://")) {
                this.fs = this.getClass().getResourceAsStream(name.substring("resource:/".length()));
                if (this.fs == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", name));
                }
                return;
            }
            this.file = new File(name);
        }
        if (this.file == null) {
            throw new IOException();
        }
        this.fs = new FileInputStream(this.file);
    }

    public InputStream getZipEntry(String extension, String namepart) {
        InputStream res;
        block6: {
            if (this.file == null) {
                return null;
            }
            res = null;
            try {
                ZipFile zipFile = new ZipFile(this.file);
                ZipEntry resentry = null;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith("." + extension) || resentry != null && entry.getName().indexOf(namepart) < 0) continue;
                    resentry = entry;
                }
                if (resentry != null) {
                    res = zipFile.getInputStream(resentry);
                } else {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                if (!this.file.getName().endsWith(".zip")) break block6;
                System.err.println(I18n.tr("Warning: failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", this.file.getName(), e.toString(), extension, namepart));
            }
        }
        return res;
    }

    public File getFile() {
        return this.file;
    }

    public static void cleanup(String name) {
        MirroredInputStream.cleanup(name, null);
    }

    public static void cleanup(String name, String destDir) {
        try {
            URL url = new URL(name);
            if (!url.getProtocol().equals("file")) {
                String[] lp;
                File lfile;
                String localPath = Main.pref.get("mirror." + url);
                if (localPath != null && localPath.length() > 0 && (lfile = new File((lp = localPath.split(";"))[1])).exists()) {
                    lfile.delete();
                }
                Main.pref.put("mirror." + url, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File checkLocal(URL url, String destDir, long maxTime) throws IOException {
        File destDirFile;
        String localPath = Main.pref.get("mirror." + url);
        File file = null;
        if (localPath != null && localPath.length() > 0) {
            String[] lp = localPath.split(";");
            file = new File(lp[1]);
            if (maxTime <= 0L) {
                maxTime = Main.pref.getInteger("mirror.maxtime", 604800);
            }
            if (System.currentTimeMillis() - Long.parseLong(lp[0]) < maxTime * 1000L && file.exists()) {
                return file;
            }
        }
        if (destDir == null) {
            destDir = Main.pref.getPreferencesDir();
        }
        if (!(destDirFile = new File(destDir)).exists()) {
            destDirFile.mkdirs();
        }
        String a = url.toString().replaceAll("[^A-Za-z0-9_.-]", "_");
        localPath = "mirror_" + a;
        destDirFile = new File(destDir, localPath + ".tmp");
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int length;
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            bis = new BufferedInputStream(conn.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(destDirFile));
            byte[] buffer = new byte[4096];
            while ((length = bis.read(buffer)) > -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, length);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            file = new File(destDir, localPath);
            destDirFile.renameTo(file);
            Main.pref.put("mirror." + url, System.currentTimeMillis() + ";" + file);
        }
        return file;
    }

    public int available() throws IOException {
        return this.fs.available();
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public int read() throws IOException {
        return this.fs.read();
    }

    public int read(byte[] b) throws IOException {
        return this.fs.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.fs.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.fs.skip(n);
    }
}

