/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;

public class CacheFiles {
    public static final int EXPIRE_NEVER = -1;
    public static final int EXPIRE_DAILY = 86400;
    public static final int EXPIRE_WEEKLY = 604800;
    public static final int EXPIRE_MONTHLY = 2419200;
    private final File dir;
    private final String ident;
    private final boolean enabled;
    private long expire;
    private long maxsize;
    private boolean updateModTime = true;
    private static final int CLEANUP_TRESHOLD = 20;
    private static final int CLEANUP_INTERVAL = 5;
    private int writes = 0;
    public static final int CLEAN_ALL = 0;
    public static final int CLEAN_SMALL_FILES = 1;
    public static final int CLEAN_BY_DATE = 2;

    public CacheFiles(String ident) {
        this(ident, true);
    }

    public CacheFiles(String ident, boolean isPlugin) {
        boolean dir_writeable;
        String pref = isPlugin ? Main.pref.getPluginsDirectory().getPath() : Main.pref.getPreferencesDir();
        this.ident = ident;
        String cacheDir = Main.pref.get("cache." + ident + "." + "path", pref + "/" + ident + "/cache/");
        this.dir = new File(cacheDir);
        try {
            this.dir.mkdirs();
            dir_writeable = true;
        }
        catch (Exception e) {
            dir_writeable = false;
        }
        this.enabled = dir_writeable;
        this.expire = Main.pref.getLong("cache." + ident + "." + "expire", 86400L);
        if (this.expire < 0L) {
            this.expire = -1L;
        }
        this.maxsize = Main.pref.getLong("cache." + ident + "." + "maxsize", 50L);
        if (this.maxsize < 0L) {
            this.maxsize = -1L;
        }
    }

    public byte[] getData(String ident) {
        if (!this.enabled) {
            return null;
        }
        try {
            File data = this.getPath(ident);
            if (!data.exists()) {
                return null;
            }
            if (this.isExpired(data)) {
                data.delete();
                return null;
            }
            if (this.updateModTime) {
                data.setLastModified(new Date().getTime());
            }
            byte[] bytes = new byte[(int)data.length()];
            new RandomAccessFile(data, "r").readFully(bytes);
            return bytes;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void saveData(String ident, byte[] data) {
        if (!this.enabled) {
            return;
        }
        try {
            File f = this.getPath(ident);
            if (f.exists()) {
                f.delete();
            }
            new RandomAccessFile(f, "rws").write(data);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ++this.writes;
        this.checkCleanUp();
    }

    public BufferedImage getImg(String ident) {
        if (!this.enabled) {
            return null;
        }
        try {
            File img = this.getPath(ident, "png");
            if (!img.exists()) {
                return null;
            }
            if (this.isExpired(img)) {
                img.delete();
                return null;
            }
            if (this.updateModTime) {
                img.setLastModified(new Date().getTime());
            }
            return ImageIO.read(img);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void saveImg(String ident, BufferedImage image) {
        if (!this.enabled) {
            return;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", this.getPath(ident, "png"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ++this.writes;
        this.checkCleanUp();
    }

    public void setExpire(int amount, boolean force) {
        String key = "cache." + this.ident + "." + "expire";
        if (Main.pref.hasKey(key) && !force) {
            return;
        }
        this.expire = amount > 0 ? (long)amount : -1L;
        Main.pref.putLong(key, this.expire);
    }

    public void setMaxSize(int amount, boolean force) {
        String key = "cache." + this.ident + "." + "maxsize";
        if (Main.pref.hasKey(key) && !force) {
            return;
        }
        this.maxsize = amount > 0 ? (long)amount : -1L;
        Main.pref.putLong(key, this.maxsize);
    }

    public void setUpdateModTime(boolean to) {
        this.updateModTime = to;
    }

    public void checkCleanUp() {
        if (this.writes > 5) {
            this.cleanUp();
        }
    }

    public void cleanUp() {
        if (!this.enabled || this.maxsize == -1L) {
            return;
        }
        TreeMap<Long, File> modtime = new TreeMap<Long, File>();
        long dirsize = 0L;
        for (File f : this.dir.listFiles()) {
            if (this.isExpired(f)) {
                f.delete();
                continue;
            }
            dirsize += f.length();
            modtime.put(f.lastModified(), f);
        }
        if (dirsize < this.maxsize * 1000L * 1000L) {
            return;
        }
        Set keySet = modtime.keySet();
        Iterator it = keySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            ((File)modtime.get(it.next())).delete();
            if (++i % 20 != 0 || this.getDirSize() >= this.maxsize) continue;
            return;
        }
        this.writes = 0;
    }

    public void customCleanUp(int type, int size) {
        switch (type) {
            case 0: {
                for (File f : this.dir.listFiles()) {
                    f.delete();
                }
                break;
            }
            case 1: {
                for (File f : this.dir.listFiles()) {
                    if (f.length() >= (long)size) continue;
                    f.delete();
                }
                break;
            }
            case 2: {
                this.cleanUp();
            }
        }
    }

    private long getDirSize() {
        if (!this.enabled) {
            return -1L;
        }
        long dirsize = 0L;
        for (File f : this.dir.listFiles()) {
            dirsize += f.length();
        }
        return dirsize;
    }

    private static String getUniqueFilename(String ident) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            BigInteger number = new BigInteger(1, md.digest(ident.getBytes()));
            return number.toString(16);
        }
        catch (Exception e) {
            ident = ident.replaceAll("[^a-zA-Z0-9]", "");
            ident = ident.replaceAll("[acegikmoqsuwy]", "");
            return ident.substring(ident.length() - 70);
        }
    }

    private File getPath(String ident, String ending) {
        return new File(this.dir, CacheFiles.getUniqueFilename(ident) + "." + ending);
    }

    private File getPath(String ident) {
        return new File(this.dir, CacheFiles.getUniqueFilename(ident));
    }

    private boolean isExpired(File file) {
        if (-1L == this.expire) {
            return false;
        }
        return file.lastModified() < new Date().getTime() - this.expire * 1000L;
    }
}

