/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AccessTokenInfoPanel;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.oauth.OsmPrivilegesPanel;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class FullyAutomaticAuthorizationUI
extends AbstractAuthorizationUI {
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private UserNameValidator valUserName;
    private PasswordValidator valPassword;
    private AccessTokenInfoPanel pnlAccessTokenInfo;
    private OsmPrivilegesPanel pnlOsmPrivileges;
    private JPanel pnlPropertiesPanel;
    private JPanel pnlActionButtonsPanel;
    private JPanel pnlResult;

    protected VerticallyScrollablePanel buildGrantsPanel() {
        this.pnlOsmPrivileges = new OsmPrivilegesPanel();
        return this.pnlOsmPrivileges;
    }

    protected VerticallyScrollablePanel buildUserNamePasswordPanel() {
        VerticallyScrollablePanel pnl = new VerticallyScrollablePanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        kit.getStyleSheet().addRule("ol {margin-left: 1cm}");
        pnlMessage.setText("<html><body><p class=\"warning-body\">" + I18n.tr("Please enter your OSM user name and password. The password will <strong>not</strong> be saved in clear text in the JOSM preferences and it will be submitted to the OSM server <strong>only once</strong>. Subsequent data upload requests don't use your password any more.") + "</p>" + "</body></html>");
        pnl.add((Component)pnlMessage, gc);
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        pnl.add((Component)new JLabel(I18n.tr("Username: ")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfUserName = new JTextField();
        pnl.add((Component)this.tfUserName, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
        this.valUserName = new UserNameValidator(this.tfUserName);
        this.valUserName.validate();
        gc.anchor = 18;
        gc.fill = 2;
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Password: ")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfPassword = new JPasswordField();
        pnl.add((Component)this.tfPassword, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfPassword);
        this.valPassword = new PasswordValidator(this.tfPassword);
        this.valPassword.validate();
        gc.gridy = 3;
        gc.gridx = 0;
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        pnlMessage = new HtmlPanel();
        kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        kit.getStyleSheet().addRule("ol {margin-left: 1cm}");
        pnlMessage.setText("<html><body><p class=\"warning-body\">" + I18n.tr("<strong>Warning:</strong> The password is transferred <strong>once</strong> in clear text to the OSM website. <strong>Do not</strong> use a sensitive password until the OSM server provides an encrypted communication channel (HTTPS).") + "</p>" + "</body></html>");
        pnl.add((Component)pnlMessage, gc);
        gc.gridy = 4;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildPropertiesPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTabbedPane tpProperties = new JTabbedPane();
        tpProperties.add(VerticallyScrollablePanel.embed(this.buildUserNamePasswordPanel()));
        tpProperties.add(VerticallyScrollablePanel.embed(this.buildGrantsPanel()));
        tpProperties.add(VerticallyScrollablePanel.embed(this.getAdvancedPropertiesPanel()));
        tpProperties.setTitleAt(0, I18n.tr("Basic"));
        tpProperties.setTitleAt(1, I18n.tr("Granted rights"));
        tpProperties.setTitleAt(2, I18n.tr("Advanced OAuth properties"));
        pnl.add((Component)tpProperties, "Center");
        return pnl;
    }

    public void initFromPreferences(Preferences pref) {
        super.initFromPreferences(pref);
        CredentialsManager cm = CredentialsManagerFactory.getCredentialManager();
        try {
            PasswordAuthentication pa = cm.lookup(Authenticator.RequestorType.SERVER);
            if (pa == null) {
                this.tfUserName.setText("");
                this.tfPassword.setText("");
            } else {
                this.tfUserName.setText(pa.getUserName() == null ? "" : pa.getUserName());
                this.tfPassword.setText(pa.getPassword() == null ? "" : String.valueOf(pa.getPassword()));
            }
        }
        catch (CredentialsManagerException e) {
            e.printStackTrace();
            this.tfUserName.setText("");
            this.tfPassword.setText("");
        }
    }

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        RunAuthorisationAction runAuthorisationAction = new RunAuthorisationAction();
        this.tfPassword.getDocument().addDocumentListener(runAuthorisationAction);
        this.tfUserName.getDocument().addDocumentListener(runAuthorisationAction);
        pnl.add(new SideButton(runAuthorisationAction));
        return pnl;
    }

    protected JPanel buildResultsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        JMultilineLabel msg = new JMultilineLabel("");
        msg.setFont(msg.getFont().deriveFont(0));
        String lbl = I18n.tr("Accept Access Token");
        msg.setText(I18n.tr("<html>You have successfully retrieved an OAuth Access Token from the OSM website. Click on <strong>{0}</strong> to accept the token. JOSM will use it in subsequent requests to gain access to the OSM API.</html>", lbl));
        pnl.add((Component)msg, gc);
        gc.gridy = 1;
        gc.insets = new Insets(5, 0, 0, 0);
        this.pnlAccessTokenInfo = new AccessTokenInfoPanel();
        pnl.add((Component)this.pnlAccessTokenInfo, gc);
        JPanel pnl1 = new JPanel(new FlowLayout(0));
        pnl1.add(new SideButton(new BackAction()));
        pnl1.add(new SideButton(new TestAccessTokenAction()));
        gc.gridy = 2;
        pnl.add((Component)pnl1, gc);
        gc.gridy = 3;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.pnlPropertiesPanel = this.buildPropertiesPanel();
        this.pnlActionButtonsPanel = this.buildActionButtonPanel();
        this.pnlResult = this.buildResultsPanel();
        this.prepareUIForEnteringRequest();
    }

    protected void prepareUIForEnteringRequest() {
        this.removeAll();
        this.add((Component)this.pnlPropertiesPanel, "Center");
        this.add((Component)this.pnlActionButtonsPanel, "South");
        this.pnlPropertiesPanel.revalidate();
        this.pnlActionButtonsPanel.revalidate();
        this.validate();
        this.repaint();
        this.setAccessToken(null);
    }

    protected void prepareUIForResultDisplay() {
        this.removeAll();
        this.add((Component)this.pnlResult, "Center");
        this.validate();
        this.repaint();
    }

    protected String getOsmUserName() {
        return this.tfUserName.getText();
    }

    protected String getOsmPassword() {
        return String.valueOf(this.tfPassword.getPassword());
    }

    public FullyAutomaticAuthorizationUI() {
        this.build();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.pnlAccessTokenInfo.isSaveToPreferences();
    }

    protected void setAccessToken(OAuthToken accessToken) {
        super.setAccessToken(accessToken);
        this.pnlAccessTokenInfo.setAccessToken(accessToken);
    }

    class FullyAutomaticAuthorisationTask
    extends PleaseWaitRunnable {
        private boolean canceled;
        private OsmOAuthAuthorizationClient authClient;

        public FullyAutomaticAuthorisationTask(Component parent) {
            super(parent, I18n.tr("Authorize JOSM to access the OSM API"), false);
        }

        protected void cancel() {
            this.canceled = true;
        }

        protected void finish() {
        }

        protected void alertAuthorisationFailed(OsmOAuthAuthorizationException e) {
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed.<br><br>Please try again or choose another kind of authorization process,<br>i.e. semi-automatic or manual authorization.</html>"), I18n.tr("OAuth authorization failed"), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void alertInvalidLoginUrl() {
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed because JOSM was not able to build<br>a valid login URL from the OAuth Authorize Endpoint URL ''{0}''.<br><br>Please check your advanced setting and try again.</html>", FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getAuthoriseUrl()), I18n.tr("OAuth authorization failed"), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void alertLoginFailed(OsmLoginFailedException e) {
            String loginUrl = null;
            try {
                loginUrl = this.authClient.buildOsmLoginUrl();
            }
            catch (OsmOAuthAuthorizationException e1) {
                this.alertInvalidLoginUrl();
                return;
            }
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed. JOSM failed to log into {0}<br>for user {1}.<br><br>Please check username and password and try again.</html>", loginUrl, FullyAutomaticAuthorizationUI.this.getOsmUserName()), I18n.tr("OAuth authorization failed"), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void handleException(final OsmOAuthAuthorizationException e) {
            Runnable r = new Runnable(){

                public void run() {
                    if (e instanceof OsmLoginFailedException) {
                        FullyAutomaticAuthorisationTask.this.alertLoginFailed((OsmLoginFailedException)e);
                    } else {
                        FullyAutomaticAuthorisationTask.this.alertAuthorisationFailed(e);
                    }
                }
            };
            e.printStackTrace();
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.getProgressMonitor().setTicksCount(3);
                this.authClient = new OsmOAuthAuthorizationClient(FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters());
                OAuthToken requestToken = this.authClient.getRequestToken(this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                this.authClient.authorise(requestToken, FullyAutomaticAuthorizationUI.this.getOsmUserName(), FullyAutomaticAuthorizationUI.this.getOsmPassword(), FullyAutomaticAuthorizationUI.this.pnlOsmPrivileges.getPrivileges(), this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                final OAuthToken accessToken = this.authClient.getAccessToken(this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                Runnable r = new Runnable(){

                    public void run() {
                        FullyAutomaticAuthorizationUI.this.prepareUIForResultDisplay();
                        FullyAutomaticAuthorizationUI.this.setAccessToken(accessToken);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
            catch (OsmOAuthAuthorizationException e) {
                this.handleException(e);
            }
        }
    }

    private static class PasswordValidator
    extends AbstractTextComponentValidator {
        public PasswordValidator(JTextComponent tc) {
            super(tc);
        }

        public boolean isValid() {
            return this.getComponent().getText().trim().length() > 0;
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter your OSM password"));
            } else {
                this.feedbackInvalid(I18n.tr("The password cannot be empty. Please enter your OSM password"));
            }
        }
    }

    private static class UserNameValidator
    extends AbstractTextComponentValidator {
        public UserNameValidator(JTextComponent tc) {
            super(tc);
        }

        public boolean isValid() {
            return this.getComponent().getText().trim().length() > 0;
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter your OSM user name"));
            } else {
                this.feedbackInvalid(I18n.tr("The user name cannot be empty. Please enter your OSM user name"));
            }
        }
    }

    class TestAccessTokenAction
    extends AbstractAction {
        public TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("about"));
        }

        public void actionPerformed(ActionEvent arg0) {
            Main.worker.submit(new TestAccessTokenTask(FullyAutomaticAuthorizationUI.this, FullyAutomaticAuthorizationUI.this.getApiUrl(), FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), FullyAutomaticAuthorizationUI.this.getAccessToken()));
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("Name", I18n.tr("Back"));
            this.putValue("ShortDescription", I18n.tr("Run the automatic authorization steps again"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "previous"));
        }

        public void actionPerformed(ActionEvent arg0) {
            FullyAutomaticAuthorizationUI.this.prepareUIForEnteringRequest();
        }
    }

    class RunAuthorisationAction
    extends AbstractAction
    implements DocumentListener {
        public RunAuthorisationAction() {
            this.putValue("Name", I18n.tr("Authorize now"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to redirect you to the authorization form on the JOSM web site"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent evt) {
            Main.worker.submit(new FullyAutomaticAuthorisationTask(FullyAutomaticAuthorizationUI.this));
        }

        protected void updateEnabledState() {
            this.setEnabled(FullyAutomaticAuthorizationUI.this.valPassword.isValid() && FullyAutomaticAuthorizationUI.this.valUserName.isValid());
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }
    }
}

