/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ImageViewerDialog
extends ToggleDialog {
    private static final String COMMAND_ZOOM = "zoom";
    private static final String COMMAND_CENTERVIEW = "centre";
    private static final String COMMAND_NEXT = "next";
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_REMOVE_FROM_DISK = "removefromdisk";
    private static final String COMMAND_PREVIOUS = "previous";
    private static final String COMMAND_COLLAPSE = "collapse";
    private ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView = false;
    private static ImageViewerDialog dialog;
    private boolean collapseButtonClicked = false;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnCollapse;
    private GeoImageLayer currentLayer = null;
    private ImageEntry currentEntry = null;

    static void newInstance() {
        dialog = new ImageViewerDialog();
    }

    public static ImageViewerDialog getInstance() {
        if (dialog == null) {
            throw new AssertionError();
        }
        return dialog;
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images"), "geoimage", I18n.tr("Display geotagged images"), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Tool: {0}", I18n.tr("Display geotagged images")), 89, 3), 200);
        if (this.isShowing && !this.isDocked) {
            this.setIsShowing(false);
        }
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)this.imgDisplay, "Center");
        Dimension buttonDim = new Dimension(26, 26);
        ImageAction prevAction = new ImageAction(COMMAND_PREVIOUS, ImageProvider.get("dialogs", COMMAND_PREVIOUS), I18n.tr("Previous"));
        this.btnPrevious = new JButton(prevAction);
        this.btnPrevious.setPreferredSize(buttonDim);
        Shortcut scPrev = Shortcut.registerShortcut("geoimage:previous", I18n.tr("Geoimage: {0}", I18n.tr("Show previous Image")), 33, 5);
        String APREVIOUS = "Previous Image";
        Main.registerActionShortcut((Action)prevAction, scPrev);
        this.btnPrevious.getInputMap(2).put(scPrev.getKeyStroke(), "Previous Image");
        this.btnPrevious.getActionMap().put("Previous Image", prevAction);
        String DELETE_TEXT = I18n.tr("Remove photo from layer");
        ImageAction delAction = new ImageAction(COMMAND_REMOVE, ImageProvider.get("dialogs", "delete"), DELETE_TEXT);
        JButton btnDelete = new JButton(delAction);
        btnDelete.setPreferredSize(buttonDim);
        Shortcut scDelete = Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr("Geoimage: {0}", DELETE_TEXT), 127, 5, 1);
        Main.registerActionShortcut((Action)delAction, scDelete);
        btnDelete.getInputMap(2).put(scDelete.getKeyStroke(), DELETE_TEXT);
        btnDelete.getActionMap().put(DELETE_TEXT, delAction);
        ImageAction delFromDiskAction = new ImageAction(COMMAND_REMOVE_FROM_DISK, ImageProvider.get("dialogs", "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk"));
        JButton btnDeleteFromDisk = new JButton(delFromDiskAction);
        btnDeleteFromDisk.setPreferredSize(buttonDim);
        Shortcut scDeleteFromDisk = Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr("Geoimage: {0}", I18n.tr("Delete File from disk")), 127, 5, 3);
        String ADELFROMDISK = "Delete image file from disk";
        Main.registerActionShortcut((Action)delFromDiskAction, scDeleteFromDisk);
        btnDeleteFromDisk.getInputMap(2).put(scDeleteFromDisk.getKeyStroke(), "Delete image file from disk");
        btnDeleteFromDisk.getActionMap().put("Delete image file from disk", delFromDiskAction);
        ImageAction nextAction = new ImageAction(COMMAND_NEXT, ImageProvider.get("dialogs", COMMAND_NEXT), I18n.tr("Next"));
        this.btnNext = new JButton(nextAction);
        this.btnNext.setPreferredSize(buttonDim);
        Shortcut scNext = Shortcut.registerShortcut("geoimage:next", I18n.tr("Geoimage: {0}", I18n.tr("Show next Image")), 34, 5);
        String ANEXT = "Next Image";
        Main.registerActionShortcut((Action)nextAction, scNext);
        this.btnNext.getInputMap(2).put(scNext.getKeyStroke(), "Next Image");
        this.btnNext.getActionMap().put("Next Image", nextAction);
        JToggleButton tbCentre = new JToggleButton(new ImageAction(COMMAND_CENTERVIEW, ImageProvider.get("dialogs", "centreview"), I18n.tr("Center view")));
        tbCentre.setPreferredSize(buttonDim);
        JButton btnZoomBestFit = new JButton(new ImageAction(COMMAND_ZOOM, ImageProvider.get("dialogs", "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1")));
        btnZoomBestFit.setPreferredSize(buttonDim);
        this.btnCollapse = new JButton(new ImageAction(COMMAND_COLLAPSE, ImageProvider.get("dialogs", COMMAND_COLLAPSE), I18n.tr("Move dialog to the side pane")));
        this.btnCollapse.setPreferredSize(new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel buttons = new JPanel();
        buttons.add(this.btnPrevious);
        buttons.add(this.btnNext);
        buttons.add(Box.createRigidArea(new Dimension(14, 0)));
        buttons.add(tbCentre);
        buttons.add(btnZoomBestFit);
        buttons.add(Box.createRigidArea(new Dimension(14, 0)));
        buttons.add(btnDelete);
        buttons.add(btnDeleteFromDisk);
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.weightx = 1.0;
        bottomPane.add((Component)buttons, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 20;
        gc.weightx = 0.0;
        bottomPane.add((Component)this.btnCollapse, gc);
        content.add((Component)bottomPane, "South");
        this.add((Component)content, "Center");
    }

    public static void showImage(GeoImageLayer layer, ImageEntry entry) {
        ImageViewerDialog.getInstance().displayImage(layer, entry);
        layer.checkPreviousNextButtons();
    }

    public static void setPreviousEnabled(Boolean value) {
        ImageViewerDialog.getInstance().btnPrevious.setEnabled(value);
    }

    public static void setNextEnabled(Boolean value) {
        ImageViewerDialog.getInstance().btnNext.setEnabled(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(GeoImageLayer layer, ImageEntry entry) {
        ImageViewerDialog imageViewerDialog = this;
        synchronized (imageViewerDialog) {
            if (this.centerView && Main.map != null && entry != null && entry.getPos() != null) {
                Main.map.mapView.zoomTo(entry.getPos());
            }
            this.currentLayer = layer;
            this.currentEntry = entry;
        }
        if (entry != null) {
            this.imgDisplay.setImage(entry.getFile());
            this.setTitle("Geotagged Images" + (entry.getFile() != null ? " - " + entry.getFile().getName() : ""));
            StringBuffer osd = new StringBuffer(entry.getFile() != null ? entry.getFile().getName() : "");
            if (entry.getElevation() != null) {
                osd.append(I18n.tr("\nAltitude: {0} m", entry.getElevation().longValue()));
            }
            if (entry.getSpeed() != null) {
                osd.append(I18n.tr("\n{0} km/h", Math.round(entry.getSpeed())));
            }
            if (entry.getExifImgDir() != null) {
                osd.append(I18n.tr("\nDirection {0}\u00b0", Math.round(entry.getExifImgDir())));
            }
            this.imgDisplay.setOsdText(osd.toString());
        } else {
            this.imgDisplay.setImage(null);
            this.imgDisplay.setOsdText("");
        }
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    protected void toggleButtonHook() {
        if (!this.isShowing) {
            this.setIsDocked(true);
            this.setIsCollapsed(false);
        }
    }

    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return true;
        }
        return false;
    }

    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    class ImageAction
    extends AbstractAction {
        private final String action;

        public ImageAction(String action, ImageIcon icon, String toolTipText) {
            this.action = action;
            this.putValue("ShortDescription", toolTipText);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.COMMAND_NEXT.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showNextPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_PREVIOUS.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showPreviousPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_CENTERVIEW.equals(this.action)) {
                ImageViewerDialog.this.centerView = ((JToggleButton)e.getSource()).isSelected();
                if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                    Main.map.mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
                }
            } else if (ImageViewerDialog.COMMAND_ZOOM.equals(this.action)) {
                ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
            } else if (ImageViewerDialog.COMMAND_REMOVE.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_REMOVE_FROM_DISK.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhotoFromDisk();
                }
            } else if (ImageViewerDialog.COMMAND_COLLAPSE.equals(this.action)) {
                ImageViewerDialog.this.collapseButtonClicked = true;
                ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
            }
        }
    }
}

