/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadSelectionDialog
extends JDialog {
    private OsmPrimitiveList lstSelectedPrimitives;
    private OsmPrimitiveList lstDeletedPrimitives;
    private JSplitPane spLists;
    private boolean canceled;
    private SideButton btnContinue;

    protected JPanel buildSelectedPrimitivesPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        JLabel lbl = new JLabel(I18n.tr("<html>Mark modified objects <strong>from the current selection</strong> to be uploaded to the server.</html>"));
        lbl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)lbl, "North");
        this.lstSelectedPrimitives = new OsmPrimitiveList();
        pnl.add((Component)new JScrollPane(this.lstSelectedPrimitives), "Center");
        return pnl;
    }

    protected JPanel buildDeletedPrimitivesPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        JLabel lbl = new JLabel(I18n.tr("<html>Mark <strong>locally deleted objects</strong> to be deleted on the server.</html>"));
        lbl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)lbl, "North");
        this.lstDeletedPrimitives = new OsmPrimitiveList();
        pnl.add((Component)new JScrollPane(this.lstDeletedPrimitives), "Center");
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout());
        ContinueAction continueAction = new ContinueAction();
        this.btnContinue = new SideButton(continueAction);
        pnl.add(this.btnContinue);
        this.btnContinue.setFocusable(true);
        this.lstDeletedPrimitives.getSelectionModel().addListSelectionListener(continueAction);
        this.lstSelectedPrimitives.getSelectionModel().addListSelectionListener(continueAction);
        pnl.add(new SideButton(new CancelAction()));
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/UploadSelection"))));
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.spLists = new JSplitPane(0);
        this.spLists.setTopComponent(this.buildSelectedPrimitivesPanel());
        this.spLists.setBottomComponent(this.buildDeletedPrimitivesPanel());
        this.add((Component)this.spLists, "Center");
        this.add((Component)this.buildButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                UploadSelectionDialog.this.spLists.setDividerLocation(0.5);
                UploadSelectionDialog.this.btnContinue.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent e) {
                UploadSelectionDialog.this.setCanceled(true);
            }
        });
        this.setTitle(I18n.tr("Select objects to upload"));
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/UploadSelection"));
    }

    public UploadSelectionDialog() {
        super((Window)JOptionPane.getFrameForComponent(Main.parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public void populate(Collection<OsmPrimitive> selected, Collection<OsmPrimitive> deleted) {
        if (selected != null) {
            this.lstSelectedPrimitives.getOsmPrimitiveListModel().setPrimitives(new ArrayList<OsmPrimitive>(selected));
            if (!selected.isEmpty()) {
                this.lstSelectedPrimitives.getSelectionModel().setSelectionInterval(0, selected.size() - 1);
            } else {
                this.lstSelectedPrimitives.getSelectionModel().clearSelection();
            }
        } else {
            this.lstSelectedPrimitives.getOsmPrimitiveListModel().setPrimitives(null);
            this.lstSelectedPrimitives.getSelectionModel().clearSelection();
        }
        if (deleted != null) {
            this.lstDeletedPrimitives.getOsmPrimitiveListModel().setPrimitives(new ArrayList<OsmPrimitive>(deleted));
        } else {
            this.lstDeletedPrimitives.getOsmPrimitiveListModel().setPrimitives(null);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public List<OsmPrimitive> getSelectedPrimitives() {
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        System.out.println("selected length:" + this.lstSelectedPrimitives.getSelectedIndices().length);
        for (int i = 0; i < this.lstSelectedPrimitives.getSelectedIndices().length; ++i) {
            System.out.println("selected:" + this.lstSelectedPrimitives.getSelectedIndices()[i]);
        }
        ret.addAll(this.lstSelectedPrimitives.getOsmPrimitiveListModel().getPrimitives(this.lstSelectedPrimitives.getSelectedIndices()));
        ret.addAll(this.lstDeletedPrimitives.getOsmPrimitiveListModel().getPrimitives(this.lstDeletedPrimitives.getSelectedIndices()));
        return ret;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(200, 400))).applySafe(this);
        } else if (!visible && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    class ContinueAction
    extends AbstractAction
    implements ListSelectionListener {
        public ContinueAction() {
            this.putValue("ShortDescription", I18n.tr("Continue uploading"));
            this.putValue("Name", I18n.tr("Continue"));
            this.putValue("SmallIcon", ImageProvider.get("", "upload"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadSelectionDialog.this.setCanceled(false);
            UploadSelectionDialog.this.setVisible(false);
        }

        protected void updateEnabledState() {
            this.setEnabled(UploadSelectionDialog.this.lstSelectedPrimitives.getSelectedIndex() >= 0 || UploadSelectionDialog.this.lstDeletedPrimitives.getSelectedIndex() >= 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel uploading"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            UploadSelectionDialog.this.setCanceled(true);
            UploadSelectionDialog.this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OsmPrimitiveListModel
    extends AbstractListModel {
        private List<OsmPrimitive> data;

        public OsmPrimitiveListModel() {
        }

        protected void sort() {
            if (this.data == null) {
                return;
            }
            Collections.sort(this.data, new Comparator<OsmPrimitive>(){
                private DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();

                @Override
                public int compare(OsmPrimitive o1, OsmPrimitive o2) {
                    int ret = OsmPrimitiveType.from(o1).compareTo(OsmPrimitiveType.from(o2));
                    if (ret != 0) {
                        return ret;
                    }
                    return o1.getDisplayName(this.formatter).compareTo(o1.getDisplayName(this.formatter));
                }
            });
        }

        public OsmPrimitiveListModel(List<OsmPrimitive> data) {
            this.setPrimitives(data);
        }

        public void setPrimitives(List<OsmPrimitive> data) {
            this.data = data;
            this.sort();
            if (data != null) {
                this.fireContentsChanged(this, 0, data.size());
            } else {
                this.fireContentsChanged(this, 0, 0);
            }
        }

        @Override
        public Object getElementAt(int index) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(index);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public List<OsmPrimitive> getPrimitives(int[] indices) {
            if (indices == null || indices.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>(indices.length);
            for (int i : indices) {
                if (i < 0) continue;
                ret.add(this.data.get(i));
            }
            return ret;
        }
    }

    static class OsmPrimitiveList
    extends JList {
        protected void init() {
            this.setSelectionMode(2);
            this.setCellRenderer(new OsmPrimitivRenderer());
        }

        public OsmPrimitiveList() {
            super(new OsmPrimitiveListModel());
            this.init();
        }

        public OsmPrimitiveList(OsmPrimitiveListModel model) {
            super(model);
            this.init();
        }

        public OsmPrimitiveListModel getOsmPrimitiveListModel() {
            return (OsmPrimitiveListModel)this.getModel();
        }
    }
}

