/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryLoadTask
extends PleaseWaitRunnable {
    private boolean cancelled = false;
    private Exception lastException = null;
    private HashSet<PrimitiveId> toLoad;
    private HistoryDataSet loadedData;

    public HistoryLoadTask() {
        super(I18n.tr("Load history"), true);
        this.toLoad = new HashSet();
    }

    public HistoryLoadTask(Component parent) {
        super(parent, I18n.tr("Load history"), true);
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
        this.toLoad = new HashSet();
    }

    public HistoryLoadTask add(long id, OsmPrimitiveType type) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got {1}.", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        SimplePrimitiveId pid = new SimplePrimitiveId(id, type);
        this.toLoad.add(pid);
        return this;
    }

    public HistoryLoadTask add(PrimitiveId pid) {
        CheckParameterUtil.ensureValidPrimitiveId(pid, "pid");
        this.toLoad.add(pid);
        return this;
    }

    public HistoryLoadTask add(HistoryOsmPrimitive primitive) {
        CheckParameterUtil.ensureParameterNotNull(primitive, "primitive");
        this.toLoad.add(primitive.getPrimitiveId());
        return this;
    }

    public HistoryLoadTask add(History history) {
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.toLoad.add(history.getPrimitmiveId());
        return this;
    }

    public HistoryLoadTask add(OsmPrimitive primitive) {
        CheckParameterUtil.ensureValidPrimitiveId(primitive, "primitive");
        this.toLoad.add(primitive.getPrimitiveId());
        return this;
    }

    public HistoryLoadTask add(Collection<? extends OsmPrimitive> primitives) {
        CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive == null) continue;
            this.add(osmPrimitive);
        }
        return this;
    }

    @Override
    protected void cancel() {
        OsmApi.getOsmApi().cancel();
        this.cancelled = true;
    }

    @Override
    protected void finish() {
        if (this.isCancelled()) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        HistoryDataSet.getInstance().mergeInto(this.loadedData);
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.loadedData = new HistoryDataSet();
        try {
            for (PrimitiveId pid : this.toLoad) {
                if (this.cancelled) break;
                String msg = "";
                switch (pid.getType()) {
                    case NODE: {
                        msg = I18n.marktr("Loading history for node {0}");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Loading history for way {0}");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Loading history for relation {0}");
                    }
                }
                this.progressMonitor.indeterminateSubTask(I18n.tr(msg, Long.toString(pid.getUniqueId())));
                OsmServerHistoryReader reader = null;
                HistoryDataSet ds = null;
                try {
                    reader = new OsmServerHistoryReader(pid.getType(), pid.getUniqueId());
                    ds = reader.parseHistory(this.progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (OsmTransferException e) {
                    if (this.cancelled) {
                        return;
                    }
                    throw e;
                }
                this.loadedData.mergeInto(ds);
            }
        }
        catch (OsmTransferException e) {
            this.lastException = e;
            return;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

