/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_DOUBLE_ENTRY = new Color(254, 226, 214);
    public static final Color BGCOLOR_SINGLE_ENTRY = new Color(235, 255, 177);
    private MemberTableModel model;

    public SelectionTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(OsmPrimitive primitive, boolean isSelected) {
        Color bgc = UIManager.getColor("Table.background");
        if (primitive != null && this.model != null && this.model.getNumMembersWithPrimitive(primitive) == 1) {
            bgc = BGCOLOR_SINGLE_ENTRY;
        } else if (primitive != null && this.model != null && this.model.getNumMembersWithPrimitive(primitive) > 1) {
            bgc = BGCOLOR_DOUBLE_ENTRY;
        }
        this.setBackground(bgc);
    }

    protected void renderPrimitive(OsmPrimitive primitive) {
        this.setIcon(ImageProvider.get(primitive.getPrimitiveId().getType()));
        this.setText(primitive.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(primitive));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        this.renderBackground((OsmPrimitive)value, isSelected);
        this.renderPrimitive((OsmPrimitive)value);
        return this;
    }

    public void setMemberTableModel(MemberTableModel model) {
        this.model = model;
    }
}

