/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UrlBasedQueryPanel
extends JPanel {
    private JTextField tfUrl;
    private JLabel lblValid;

    protected JPanel buildURLPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.0;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 0, 5);
        pnl.add((Component)new JLabel(I18n.tr("URL: ")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.tfUrl = new JTextField();
        pnl.add((Component)this.tfUrl, gc);
        this.tfUrl.getDocument().addDocumentListener(new ChangetQueryUrlValidator());
        this.tfUrl.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                UrlBasedQueryPanel.this.tfUrl.selectAll();
            }
        });
        gc.gridx = 2;
        gc.weightx = 0.0;
        gc.fill = 2;
        this.lblValid = new JLabel();
        pnl.add((Component)this.lblValid, gc);
        this.lblValid.setPreferredSize(new Dimension(20, 20));
        return pnl;
    }

    protected JPanel buildHelpPanel() {
        HtmlPanel pnl = new HtmlPanel();
        pnl.setText("<html><body>" + I18n.tr("Please enter or paste an URL to retrieve changesets from the OSM API.") + "<p><strong>" + I18n.tr("Examples") + "</strong></p>" + "<ul>" + "<li><a href=\"http://www.openstreetmap.org/browse/changesets?open=true\">http://www.openstreetmap.org/browse/changesets?open=true</a></li>" + "<li><a href=\"http://api.openstreetmap.org/api/0.6/changesets?open=true\">http://api.openstreetmap.org/api/0.6/changesets?open=true</a></li>" + "</ul>" + I18n.tr("Note that changeset queries are currently always submitted to ''{0}'', regardless of the host, port and path of the URL entered below.", OsmApi.getOsmApi().getBaseUrl()) + "</body></html>");
        pnl.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    UrlBasedQueryPanel.this.tfUrl.setText(e.getDescription());
                    UrlBasedQueryPanel.this.tfUrl.requestFocusInWindow();
                }
            }
        });
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.buildHelpPanel(), gc);
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.add((Component)this.buildURLPanel(), gc);
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)new JPanel(), gc);
    }

    public UrlBasedQueryPanel() {
        this.build();
    }

    protected boolean isValidChangesetQueryUrl(String text) {
        return this.buildChangesetQuery(text) != null;
    }

    protected ChangesetQuery buildChangesetQuery(String text) {
        URL url = null;
        try {
            url = new URL(text);
        }
        catch (MalformedURLException e) {
            return null;
        }
        String path = url.getPath();
        String query = url.getQuery();
        if (path == null || !path.endsWith("/changesets")) {
            return null;
        }
        try {
            return ChangesetQuery.buildFromUrlQuery(query);
        }
        catch (ChangesetQuery.ChangesetQueryUrlException e) {
            return null;
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        String value = this.tfUrl.getText().trim();
        return this.buildChangesetQuery(value);
    }

    public void startUserInput() {
        this.tfUrl.requestFocusInWindow();
    }

    class ChangetQueryUrlValidator
    implements DocumentListener {
        ChangetQueryUrlValidator() {
        }

        protected String getCurrentFeedback() {
            String fb = (String)UrlBasedQueryPanel.this.lblValid.getClientProperty("valid");
            return fb == null ? "none" : fb;
        }

        protected void feedbackValid() {
            if (this.getCurrentFeedback().equals("valid")) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("dialogs/changeset", "valid"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText("");
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "valid");
        }

        protected void feedbackInvalid() {
            if (this.getCurrentFeedback().equals("invalid")) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText(I18n.tr("This changeset query URL is invalid"));
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "invalid");
        }

        protected void feedbackNone() {
            UrlBasedQueryPanel.this.lblValid.setIcon(null);
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "none");
        }

        protected void validate() {
            String value = UrlBasedQueryPanel.this.tfUrl.getText();
            if (value.trim().equals("")) {
                this.feedbackNone();
                return;
            }
            if (UrlBasedQueryPanel.this.isValidChangesetQueryUrl(value = value.trim())) {
                this.feedbackValid();
            } else {
                this.feedbackInvalid();
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }
    }
}

