/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberConflictResolver
extends JPanel {
    private AutoCompletingTextField tfRole;
    private AutoCompletingTextField tfKey;
    private AutoCompletingTextField tfValue;
    private JCheckBox cbTagRelations;
    private RelationMemberConflictResolverModel model;
    private RelationMemberConflictResolverTable tblResolver;
    private JMultilineLabel lblHeader;

    protected void build() {
        this.setLayout(new GridBagLayout());
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        this.lblHeader = new JMultilineLabel("");
        pnl.add(this.lblHeader);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weighty = 0.0;
        gc.weightx = 1.0;
        gc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)pnl, gc);
        this.model = new RelationMemberConflictResolverModel();
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(0, 0, 0, 0);
        this.tblResolver = new RelationMemberConflictResolverTable(this.model);
        this.add((Component)new JScrollPane(this.tblResolver), gc);
        pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.add(this.buildRoleEditingPanel());
        pnl.add(this.buildTagRelationsPanel());
        gc.gridy = 2;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.add((Component)pnl, gc);
    }

    protected JPanel buildRoleEditingPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        pnl.add(new JLabel(I18n.tr("Role:")));
        this.tfRole = new AutoCompletingTextField(10);
        pnl.add(this.tfRole);
        this.tfRole.setToolTipText(I18n.tr("Enter a role for all relation memberships"));
        pnl.add(new JButton(new ApplyRoleAction()));
        this.tfRole.addActionListener(new ApplyRoleAction());
        this.tfRole.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                RelationMemberConflictResolver.this.tfRole.selectAll();
            }
        });
        return pnl;
    }

    protected JPanel buildTagRelationsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        this.cbTagRelations = new JCheckBox(I18n.tr("Tag modified relations with "));
        this.cbTagRelations.addChangeListener(new ToggleTagRelationsAction());
        this.cbTagRelations.setToolTipText(I18n.tr("<html>Select to enable entering a tag which will be applied<br>to all modified relations.</html>"));
        pnl.add(this.cbTagRelations);
        pnl.add(new JLabel(I18n.trc("tag", "Key:")));
        this.tfKey = new AutoCompletingTextField(10);
        pnl.add(this.tfKey);
        this.tfKey.setToolTipText(I18n.tr("<html>Enter a tag key, i.e. <strong><tt>fixme</tt></strong></html>"));
        pnl.add(new JLabel(I18n.tr("Value:")));
        this.tfValue = new AutoCompletingTextField(10);
        pnl.add(this.tfValue);
        this.tfValue.setToolTipText(I18n.tr("<html>Enter a tag value, i.e. <strong><tt>check members</tt></strong></html>"));
        this.cbTagRelations.setSelected(false);
        this.tfKey.setEnabled(false);
        this.tfValue.setEnabled(false);
        return pnl;
    }

    public RelationMemberConflictResolver() {
        this.build();
    }

    public void initForWayCombining() {
        this.lblHeader.setText(I18n.tr("<html>The combined ways are members in one ore more relations. Please decide whether you want to <strong>keep</strong> these memberships for the combined way or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first way and <strong>remove</strong> the other ways that are members of the same relation: the combined way will take the place of the original way in the relation.</html>"));
        this.invalidate();
    }

    public void initForNodeMerging() {
        this.lblHeader.setText(I18n.tr("<html>The merged nodes are members in one ore more relations. Please decide whether you want to <strong>keep</strong> these memberships for the target node or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first node and <strong>remove</strong> the other nodes that are members of the same relation: the target node will take the place of the original node in the relation.</html>"));
        this.invalidate();
    }

    public RelationMemberConflictResolverModel getModel() {
        return this.model;
    }

    public Command buildTagApplyCommands(Collection<? extends OsmPrimitive> primitives) {
        if (!this.cbTagRelations.isSelected()) {
            return null;
        }
        if (this.tfKey.getText().trim().equals("")) {
            return null;
        }
        if (this.tfValue.getText().trim().equals("")) {
            return null;
        }
        if (primitives == null || primitives.isEmpty()) {
            return null;
        }
        return new ChangePropertyCommand(primitives, this.tfKey.getText(), this.tfValue.getText());
    }

    public void prepareForEditing() {
        AutoCompletionList acList = new AutoCompletionList();
        Main.main.getEditLayer().data.getAutoCompletionManager().populateWithMemberRoles(acList);
        this.tfRole.setAutoCompletionList(acList);
        AutoCompletingTextField editor = (AutoCompletingTextField)this.tblResolver.getColumnModel().getColumn(2).getCellEditor();
        if (editor != null) {
            editor.setAutoCompletionList(acList);
        }
        AutoCompletionList acList2 = new AutoCompletionList();
        Main.main.getEditLayer().data.getAutoCompletionManager().populateWithKeys(acList2);
        this.tfKey.setAutoCompletionList(acList2);
    }

    class ToggleTagRelationsAction
    implements ChangeListener {
        ToggleTagRelationsAction() {
        }

        public void stateChanged(ChangeEvent e) {
            ButtonModel buttonModel = ((AbstractButton)e.getSource()).getModel();
            RelationMemberConflictResolver.this.tfKey.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfValue.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfKey.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            RelationMemberConflictResolver.this.tfValue.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
        }
    }

    class ApplyRoleAction
    extends AbstractAction {
        public ApplyRoleAction() {
            this.putValue("Name", I18n.tr("Apply"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Apply this role to all members"));
        }

        public void actionPerformed(ActionEvent e) {
            RelationMemberConflictResolver.this.model.applyRole(RelationMemberConflictResolver.this.tfRole.getText());
        }
    }
}

