/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Color;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class MineTableCellRenderer
extends TagMergeTableCellRenderer {
    public static final Color BGCOLOR_UNDECIDED = new Color(255, 197, 197);
    public static final Color BGCOLOR_MINE = new Color(217, 255, 217);
    public static final Color BGCOLOR_THEIR = Color.white;
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);

    protected void setBackgroundColor(TagMergeItem item, boolean isSelected) {
        if (isSelected) {
            this.setBackground(BGCOLOR_SELECTED);
            return;
        }
        if (MergeDecisionType.KEEP_MINE.equals((Object)item.getMergeDecision())) {
            this.setBackground(BGCOLOR_MINE);
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)item.getMergeDecision())) {
            this.setBackground(BGCOLOR_THEIR);
        } else if (MergeDecisionType.UNDECIDED.equals((Object)item.getMergeDecision())) {
            this.setBackground(BGCOLOR_UNDECIDED);
        }
    }

    protected void setTextColor(TagMergeItem item) {
        if (MergeDecisionType.KEEP_MINE.equals((Object)item.getMergeDecision())) {
            this.setForeground(Color.black);
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)item.getMergeDecision())) {
            this.setForeground(Color.LIGHT_GRAY);
        } else if (MergeDecisionType.UNDECIDED.equals((Object)item.getMergeDecision())) {
            this.setForeground(Color.black);
        }
    }

    protected void renderKey(TagMergeItem item, boolean isSelected) {
        this.setBackgroundColor(item, isSelected);
        this.setTextColor(item);
        if (item.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("My dataset does not include a tag with key {0}", item.getKey()));
        } else {
            this.setText(item.getKey());
            this.setToolTipText(item.getKey());
        }
    }

    protected void renderValue(TagMergeItem item, boolean isSelected) {
        this.setBackgroundColor(item, isSelected);
        this.setTextColor(item);
        if (item.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("My dataset does not include a tag with key {0}", item.getKey()));
        } else {
            this.setText(item.getMyTagValue());
            this.setToolTipText(item.getMyTagValue());
        }
    }
}

