/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCollection
implements Iterable<Tag> {
    private final HashSet<Tag> tags = new HashSet();

    public static TagCollection from(Tagged primitive) {
        TagCollection tags = new TagCollection();
        for (String key : primitive.keySet()) {
            tags.add(new Tag(key, primitive.get(key)));
        }
        return tags;
    }

    public static TagCollection from(Map<String, String> tags) {
        TagCollection ret = new TagCollection();
        if (tags == null) {
            return ret;
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey() == null ? "" : entry.getKey();
            String value = entry.getValue() == null ? "" : entry.getValue();
            ret.add(new Tag(key, value));
        }
        return ret;
    }

    public static TagCollection unionOfAllPrimitives(Collection<? extends Tagged> primitives) {
        TagCollection tags = new TagCollection();
        if (primitives == null) {
            return tags;
        }
        for (Tagged tagged : primitives) {
            if (tagged == null) continue;
            tags.add(TagCollection.from(tagged));
        }
        return tags;
    }

    public static TagCollection commonToAllPrimitives(Collection<? extends Tagged> primitives) {
        TagCollection tags = new TagCollection();
        if (primitives == null || primitives.isEmpty()) {
            return tags;
        }
        tags.add(TagCollection.from(primitives.iterator().next()));
        for (Tagged tagged : primitives) {
            if (tagged == null) continue;
            tags.add(tags.intersect(TagCollection.from(tagged)));
        }
        return tags;
    }

    public static TagCollection unionOfAllPrimitives(DataSet ds) {
        TagCollection tags = new TagCollection();
        if (ds == null) {
            return tags;
        }
        tags.add(TagCollection.unionOfAllPrimitives(ds.allPrimitives()));
        return tags;
    }

    public TagCollection() {
    }

    public TagCollection(TagCollection other) {
        if (other != null) {
            this.tags.addAll(other.tags);
        }
    }

    public int size() {
        return this.tags.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void add(Tag tag) {
        if (tag == null) {
            return;
        }
        if (this.tags.contains(tag)) {
            return;
        }
        this.tags.add(tag);
    }

    public void add(Collection<Tag> tags) {
        if (tags == null) {
            return;
        }
        for (Tag tag : tags) {
            this.add(tag);
        }
    }

    public void add(TagCollection tags) {
        if (tags == null) {
            return;
        }
        this.tags.addAll(tags.tags);
    }

    public void remove(Tag tag) {
        if (tag == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void remove(Collection<Tag> tags) {
        if (tags == null) {
            return;
        }
        this.tags.removeAll(tags);
    }

    public void remove(TagCollection tags) {
        if (tags == null) {
            return;
        }
        this.tags.removeAll(tags.tags);
    }

    public void removeByKey(String key) {
        if (key == null) {
            return;
        }
        Iterator<Tag> it = this.tags.iterator();
        while (it.hasNext()) {
            if (!it.next().matchesKey(key)) continue;
            it.remove();
        }
    }

    public void removeByKey(Collection<String> keys) {
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            this.removeByKey(key);
        }
    }

    public boolean contains(Tag tag) {
        return this.tags.contains(tag);
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Tag> tags) {
        if (tags == null) {
            return false;
        }
        return this.tags.containsAll(tags);
    }

    public boolean containsAllKeys(Collection<String> keys) {
        if (keys == null) {
            return false;
        }
        for (String key : keys) {
            if (key == null || this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public int getNumTagsFor(String key) {
        if (key == null) {
            return 0;
        }
        int count = 0;
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(key)) continue;
            ++count;
        }
        return count;
    }

    public boolean hasTagsFor(String key) {
        return this.getNumTagsFor(key) > 0;
    }

    public boolean hasValuesFor(String key) {
        if (key == null) {
            return false;
        }
        Set<String> values = this.getTagsFor(key).getValues();
        values.remove("");
        return !values.isEmpty();
    }

    public boolean hasUniqueNonEmptyValue(String key) {
        if (key == null) {
            return false;
        }
        Set<String> values = this.getTagsFor(key).getValues();
        return values.size() == 1 && !values.contains("");
    }

    public boolean hasEmptyValue(String key) {
        if (key == null) {
            return false;
        }
        Set<String> values = this.getTagsFor(key).getValues();
        return values.contains("");
    }

    public boolean hasUniqueEmptyValue(String key) {
        if (key == null) {
            return false;
        }
        Set<String> values = this.getTagsFor(key).getValues();
        return values.size() == 1 && values.contains("");
    }

    public TagCollection getTagsFor(String key) {
        TagCollection ret = new TagCollection();
        if (key == null) {
            return ret;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(key)) continue;
            ret.add(tag);
        }
        return ret;
    }

    public TagCollection getTagsFor(Collection<String> keys) {
        TagCollection ret = new TagCollection();
        if (keys == null) {
            return ret;
        }
        for (String key : keys) {
            if (key == null) continue;
            ret.add(this.getTagsFor(key));
        }
        return ret;
    }

    public Set<Tag> asSet() {
        return new HashSet<Tag>(this.tags);
    }

    public List<Tag> asList() {
        return new ArrayList<Tag>(this.tags);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tags.iterator();
    }

    public Set<String> getKeys() {
        HashSet<String> ret = new HashSet<String>();
        for (Tag tag : this.tags) {
            ret.add(tag.getKey());
        }
        return ret;
    }

    public Set<String> getKeysWithMultipleValues() {
        HashMap<String, Integer> counters = new HashMap<String, Integer>();
        for (Tag tag : this.tags) {
            Integer v = (Integer)counters.get(tag.getKey());
            counters.put(tag.getKey(), v == null ? 1 : v + 1);
        }
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry e : counters.entrySet()) {
            if ((Integer)e.getValue() <= 1) continue;
            ret.add((String)e.getKey());
        }
        return ret;
    }

    public void setUniqueForKey(Tag tag) {
        if (tag == null) {
            return;
        }
        this.removeByKey(tag.getKey());
        this.add(tag);
    }

    public void setUniqueForKey(String key, String value) {
        Tag tag = new Tag(key, value);
        this.setUniqueForKey(tag);
    }

    public Set<String> getValues() {
        HashSet<String> ret = new HashSet<String>();
        for (Tag tag : this.tags) {
            ret.add(tag.getValue());
        }
        return ret;
    }

    public Set<String> getValues(String key) {
        HashSet<String> ret = new HashSet<String>();
        if (key == null) {
            return ret;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(key)) continue;
            ret.add(tag.getValue());
        }
        return ret;
    }

    public boolean isApplicableToPrimitive() {
        return this.size() == this.getKeys().size();
    }

    public void applyTo(Tagged primitive) throws IllegalStateException {
        if (primitive == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values."));
        }
        for (Tag tag : this.tags) {
            if (tag.getValue() == null || tag.getValue().equals("")) {
                primitive.remove(tag.getKey());
                continue;
            }
            primitive.put(tag.getKey(), tag.getValue());
        }
    }

    public void applyTo(Collection<? extends Tagged> primitives) throws IllegalStateException {
        if (primitives == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values."));
        }
        for (Tagged tagged : primitives) {
            this.applyTo(tagged);
        }
    }

    public void replaceTagsOf(Tagged primitive) throws IllegalStateException {
        if (primitive == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values."));
        }
        primitive.removeAll();
        for (Tag tag : this.tags) {
            primitive.put(tag.getKey(), tag.getValue());
        }
    }

    public void replaceTagsOf(Collection<? extends Tagged> primitives) throws IllegalStateException {
        if (primitives == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values."));
        }
        for (Tagged tagged : primitives) {
            this.replaceTagsOf(tagged);
        }
    }

    public TagCollection intersect(TagCollection other) {
        if (other == null) {
            other = new TagCollection();
        }
        TagCollection ret = new TagCollection(this);
        for (Tag tag : this.tags) {
            if (!other.contains(tag)) continue;
            ret.add(tag);
        }
        return ret;
    }

    public TagCollection minus(TagCollection other) {
        TagCollection ret = new TagCollection(this);
        if (other != null) {
            ret.remove(other);
        }
        return ret;
    }

    public TagCollection union(TagCollection other) {
        TagCollection ret = new TagCollection(this);
        if (other != null) {
            ret.add(other);
        }
        return ret;
    }

    public TagCollection emptyTagsForKeysMissingIn(TagCollection other) {
        TagCollection ret = new TagCollection();
        for (String key : this.minus(other).getKeys()) {
            ret.add(new Tag(key));
        }
        return ret;
    }

    public String getJoinedValues(String key) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> values = new ArrayList<String>(this.getValues(key));
        values.remove("");
        Collections.sort(values);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            buffer.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(";");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.tags.toString();
    }
}

