/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    private static final int MAX_SINGLE_EVENTS = 30;
    private static final int MAX_EVENTS = 1000;
    private Storage<OsmPrimitive> allPrimitives = new Storage<OsmPrimitive>(new IdHash(), true);
    private Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new IdHash());
    private CopyOnWriteArrayList<DataSetListener> listeners = new CopyOnWriteArrayList();
    private int updateCount;
    private final List<AbstractDatasetChangedEvent> cachedEvents = new ArrayList<AbstractDatasetChangedEvent>();
    private int highlightUpdateCount;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object selectionLock = new Object();
    private AutoCompletionManager autocomplete;
    private String version;
    private QuadBuckets<Node> nodes = new QuadBuckets();
    private QuadBuckets<Way> ways = new QuadBuckets();
    private Collection<Relation> relations = new ArrayList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    @Deprecated
    public static final Collection<SelectionChangedListener> selListeners = new CopyOnWriteArrayList<SelectionChangedListener>();
    private LinkedHashSet<OsmPrimitive> selectedPrimitives = new LinkedHashSet();
    private Collection<OsmPrimitive> selectionSnapshot;

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public int getHighlightUpdateCount() {
        return this.highlightUpdateCount;
    }

    public AutoCompletionManager getAutoCompletionManager() {
        if (this.autocomplete == null) {
            this.autocomplete = new AutoCompletionManager(this);
            this.addDataSetListener(this.autocomplete);
        }
        return this.autocomplete;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<OsmPrimitive> predicate) {
        return new DatasetCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(OsmPrimitive.nodePredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> searchNodes(BBox bbox) {
        this.lock.readLock().lock();
        try {
            List<Node> list = this.nodes.search(bbox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(OsmPrimitive.wayPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Way> searchWays(BBox bbox) {
        this.lock.readLock().lock();
        try {
            List<Way> list = this.ways.search(bbox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(OsmPrimitive.relationPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relation> searchRelations(BBox bbox) {
        this.lock.readLock().lock();
        try {
            ArrayList<Relation> result = new ArrayList<Relation>();
            for (Relation r : this.relations) {
                if (!r.getBBox().intersects(bbox)) continue;
                result.add(r);
            }
            ArrayList<Relation> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(OsmPrimitive.allPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedCompletePredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPhysicalPredicate);
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(OsmPrimitive.modifiedPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimitive(OsmPrimitive primitive) {
        this.beginUpdate();
        try {
            if (this.getPrimitiveById(primitive) != null) {
                throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", primitive.toString()));
            }
            primitive.updatePosition();
            boolean success = false;
            if (primitive instanceof Node) {
                success = this.nodes.add((Node)primitive);
            } else if (primitive instanceof Way) {
                success = this.ways.add((Way)primitive);
            } else if (primitive instanceof Relation) {
                success = this.relations.add((Relation)primitive);
            }
            if (!success) {
                throw new RuntimeException("failed to add primitive: " + primitive);
            }
            this.allPrimitives.add(primitive);
            primitive.setDataset(this);
            this.firePrimitivesAdded(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimitive(PrimitiveId primitiveId) {
        this.beginUpdate();
        try {
            OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
            if (primitive == null) {
                return;
            }
            boolean success = false;
            if (primitive instanceof Node) {
                success = this.nodes.remove(primitive);
            } else if (primitive instanceof Way) {
                success = this.ways.remove(primitive);
            } else if (primitive instanceof Relation) {
                success = this.relations.remove(primitive);
            }
            if (!success) {
                throw new RuntimeException("failed to remove primitive: " + primitive);
            }
            Object object = this.selectionLock;
            synchronized (object) {
                this.selectedPrimitives.remove(primitive);
                this.selectionSnapshot = null;
            }
            this.allPrimitives.remove(primitive);
            primitive.setDataset(null);
            this.firePrimitivesRemoved(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public static void addSelectionListener(SelectionChangedListener listener) {
        ((CopyOnWriteArrayList)selListeners).addIfAbsent(listener);
    }

    public static void removeSelectionListener(SelectionChangedListener listener) {
        selListeners.remove(listener);
    }

    public void fireSelectionChanged() {
        Collection<OsmPrimitive> currentSelection = this.getSelected();
        for (SelectionChangedListener l : selListeners) {
            l.selectionChanged(currentSelection);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        return new DatasetCollection<OsmPrimitive>(this.getSelected(), new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive primitive) {
                return primitive instanceof Node || primitive instanceof Way;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OsmPrimitive> getSelected() {
        Collection<OsmPrimitive> currentList;
        Object object = this.selectionLock;
        synchronized (object) {
            if (this.selectionSnapshot == null) {
                this.selectionSnapshot = Collections.unmodifiableList(new ArrayList<OsmPrimitive>(this.selectedPrimitives));
            }
            currentList = this.selectionSnapshot;
        }
        return currentList;
    }

    public Collection<Node> getSelectedNodes() {
        return new DatasetCollection<Node>(this.getSelected(), OsmPrimitive.nodePredicate);
    }

    public Collection<Way> getSelectedWays() {
        return new DatasetCollection<Way>(this.getSelected(), OsmPrimitive.wayPredicate);
    }

    public Collection<Relation> getSelectedRelations() {
        return new DatasetCollection<Relation>(this.getSelected(), OsmPrimitive.relationPredicate);
    }

    public boolean selectionEmpty() {
        return this.selectedPrimitives.isEmpty();
    }

    public boolean isSelected(OsmPrimitive osm) {
        return this.selectedPrimitives.contains(osm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleSelected(Collection<? extends PrimitiveId> osm) {
        boolean changed = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : osm) {
                changed |= this.__toggleSelected(primitiveId);
            }
            if (changed) {
                this.selectionSnapshot = null;
            }
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void toggleSelected(PrimitiveId ... osm) {
        this.toggleSelected(Arrays.asList(osm));
    }

    private boolean __toggleSelected(PrimitiveId primitiveId) {
        OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
        if (primitive == null) {
            return false;
        }
        if (!this.selectedPrimitives.remove(primitive)) {
            this.selectedPrimitives.add(primitive);
        }
        this.selectionSnapshot = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(Collection<? extends PrimitiveId> selection, boolean fireSelectionChangeEvent) {
        boolean changed;
        Object object = this.selectionLock;
        synchronized (object) {
            boolean wasEmpty = this.selectedPrimitives.isEmpty();
            this.selectedPrimitives = new LinkedHashSet();
            boolean bl = changed = this.addSelected(selection, false) || !wasEmpty && this.selectedPrimitives.isEmpty();
            if (changed) {
                this.selectionSnapshot = null;
            }
        }
        if (changed && fireSelectionChangeEvent) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(Collection<? extends PrimitiveId> selection) {
        this.setSelected(selection, true);
    }

    public void setSelected(PrimitiveId ... osm) {
        if (osm.length == 1 && osm[0] == null) {
            this.setSelected(new PrimitiveId[0]);
            return;
        }
        List<PrimitiveId> list = Arrays.asList(osm);
        this.setSelected(list);
    }

    public void addSelected(Collection<? extends PrimitiveId> selection) {
        this.addSelected(selection, true);
    }

    public void addSelected(PrimitiveId ... osm) {
        this.addSelected(Arrays.asList(osm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSelected(Collection<? extends PrimitiveId> selection, boolean fireSelectionChangeEvent) {
        boolean changed = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : selection) {
                OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
                if (primitive == null) continue;
                changed |= this.selectedPrimitives.add(primitive);
            }
            if (changed) {
                this.selectionSnapshot = null;
            }
        }
        if (fireSelectionChangeEvent && changed) {
            this.fireSelectionChanged();
        }
        return changed;
    }

    public void clearSelection(PrimitiveId ... osm) {
        this.clearSelection(Arrays.asList(osm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection(Collection<? extends PrimitiveId> list) {
        boolean changed = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : list) {
                OsmPrimitive primitive = this.getPrimitiveById(primitiveId);
                if (primitive == null) continue;
                changed |= this.selectedPrimitives.remove(primitive);
            }
            if (changed) {
                this.selectionSnapshot = null;
            }
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        if (!this.selectedPrimitives.isEmpty()) {
            Object object = this.selectionLock;
            synchronized (object) {
                this.selectedPrimitives.clear();
                this.selectionSnapshot = null;
            }
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet clone() {
        this.getReadLock().lock();
        try {
            Relation newRelation;
            DataSet ds = new DataSet();
            HashMap<OsmPrimitive, OsmPrimitive> primMap = new HashMap<OsmPrimitive, OsmPrimitive>();
            for (Node n : this.nodes) {
                Node newNode = new Node(n);
                primMap.put(n, newNode);
                ds.addPrimitive(newNode);
            }
            for (Way w : this.ways) {
                Way newWay = new Way(w);
                primMap.put(w, newWay);
                ArrayList<Node> newNodes = new ArrayList<Node>();
                for (Node n : w.getNodes()) {
                    newNodes.add((Node)primMap.get(n));
                }
                newWay.setNodes(newNodes);
                ds.addPrimitive(newWay);
            }
            for (Relation r : this.relations) {
                newRelation = new Relation(r, r.isNew());
                newRelation.setMembers(null);
                primMap.put(r, newRelation);
                ds.addPrimitive(newRelation);
            }
            for (Relation r : this.relations) {
                newRelation = (Relation)primMap.get(r);
                ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
                for (RelationMember rm : r.getMembers()) {
                    newMembers.add(new RelationMember(rm.getRole(), (OsmPrimitive)primMap.get(rm.getMember())));
                }
                newRelation.setMembers(newMembers);
            }
            for (DataSource source : this.dataSources) {
                ds.dataSources.add(new DataSource(source.bounds, source.origin));
            }
            ds.version = this.version;
            DataSet dataSet = ds;
            return dataSet;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area a = new Area();
        for (DataSource source : this.dataSources) {
            a.add(new Area(source.bounds.asRect()));
        }
        return a;
    }

    public OsmPrimitive getPrimitiveById(long id, OsmPrimitiveType type) {
        return this.getPrimitiveById(new SimplePrimitiveId(id, type));
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return this.primitivesMap.get(primitiveId);
    }

    @Deprecated
    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId, boolean createNew) {
        OsmPrimitive result = this.primitivesMap.get(primitiveId);
        if (result == null && createNew) {
            switch (primitiveId.getType()) {
                case NODE: {
                    result = new Node(primitiveId.getUniqueId(), true);
                    break;
                }
                case WAY: {
                    result = new Way(primitiveId.getUniqueId(), true);
                    break;
                }
                case RELATION: {
                    result = new Relation(primitiveId.getUniqueId(), true);
                }
            }
            this.addPrimitive(result);
        }
        return result;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive result = this.getPrimitiveById(primitiveId);
        if (result == null) {
            System.out.println(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this  at http://josm.openstreetmap.de . This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId())}));
            new Exception().printStackTrace();
        }
        return result;
    }

    private void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkNodeFromWays(Node node) {
        this.beginUpdate();
        try {
            for (Way way : this.ways) {
                List<Node> wayNodes = way.getNodes();
                if (!wayNodes.remove(node)) continue;
                if (wayNodes.size() < 2) {
                    this.deleteWay(way);
                    continue;
                }
                way.setNodes(wayNodes);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkPrimitiveFromRelations(OsmPrimitive primitive) {
        this.beginUpdate();
        try {
            for (Relation relation : this.relations) {
                List<RelationMember> members = relation.getMembers();
                Iterator<RelationMember> it = members.iterator();
                boolean removed = false;
                while (it.hasNext()) {
                    RelationMember member = it.next();
                    if (!member.getMember().equals(primitive)) continue;
                    it.remove();
                    removed = true;
                }
                if (!removed) continue;
                relation.setMembers(members);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkReferencesToPrimitive(OsmPrimitive referencedPrimitive) {
        this.beginUpdate();
        try {
            if (referencedPrimitive instanceof Node) {
                this.unlinkNodeFromWays((Node)referencedPrimitive);
                this.unlinkPrimitiveFromRelations(referencedPrimitive);
            } else {
                this.unlinkPrimitiveFromRelations(referencedPrimitive);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean isModified() {
        for (OsmPrimitive p : this.allPrimitives) {
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }

    private void reindexNode(Node node, LatLon newCoor, EastNorth eastNorth) {
        if (!this.nodes.remove(node)) {
            throw new RuntimeException("Reindexing node failed to remove");
        }
        node.setCoorInternal(newCoor, eastNorth);
        if (!this.nodes.add(node)) {
            throw new RuntimeException("Reindexing node failed to add");
        }
        for (OsmPrimitive primitive : node.getReferrers()) {
            if (primitive instanceof Way) {
                this.reindexWay((Way)primitive);
                continue;
            }
            this.reindexRelation((Relation)primitive);
        }
    }

    private void reindexWay(Way way) {
        BBox before = way.getBBox();
        if (!this.ways.remove(way)) {
            throw new RuntimeException("Reindexing way failed to remove");
        }
        way.updatePosition();
        if (!this.ways.add(way)) {
            throw new RuntimeException("Reindexing way failed to add");
        }
        if (!way.getBBox().equals(before)) {
            for (OsmPrimitive primitive : way.getReferrers()) {
                this.reindexRelation((Relation)primitive);
            }
        }
    }

    private void reindexRelation(Relation relation) {
        BBox before = relation.getBBox();
        relation.updatePosition();
        if (!before.equals(relation.getBBox())) {
            for (OsmPrimitive primitive : relation.getReferrers()) {
                this.reindexRelation((Relation)primitive);
            }
        }
    }

    public void addDataSetListener(DataSetListener dsl) {
        this.listeners.addIfAbsent(dsl);
    }

    public void removeDataSetListener(DataSetListener dsl) {
        this.listeners.remove(dsl);
    }

    public void beginUpdate() {
        this.lock.writeLock().lock();
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            if (this.updateCount == 0) {
                ArrayList<AbstractDatasetChangedEvent> eventsCopy = new ArrayList<AbstractDatasetChangedEvent>(this.cachedEvents);
                this.cachedEvents.clear();
                this.lock.writeLock().unlock();
                if (!eventsCopy.isEmpty()) {
                    this.lock.readLock().lock();
                    try {
                        if (eventsCopy.size() < 30) {
                            for (AbstractDatasetChangedEvent event : eventsCopy) {
                                this.fireEventToListeners(event);
                            }
                        }
                        if (eventsCopy.size() == 1000) {
                            this.fireEventToListeners(new DataChangedEvent(this));
                        }
                        this.fireEventToListeners(new DataChangedEvent(this, eventsCopy));
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                }
            } else {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEventToListeners(AbstractDatasetChangedEvent event) {
        for (DataSetListener listener : this.listeners) {
            event.fire(listener);
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent event) {
        if (this.updateCount == 0) {
            throw new AssertionError((Object)"dataset events can be fired only when dataset is locked");
        }
        if (this.cachedEvents.size() < 1000) {
            this.cachedEvents.add(event);
        }
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> added, boolean wasIncomplete) {
        this.fireEvent(new PrimitivesAddedEvent(this, added, wasIncomplete));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> removed, boolean wasComplete) {
        this.fireEvent(new PrimitivesRemovedEvent(this, removed, wasComplete));
    }

    void fireTagsChanged(OsmPrimitive prim, Map<String, String> originalKeys) {
        this.fireEvent(new TagsChangedEvent(this, prim, originalKeys));
    }

    void fireRelationMembersChanged(Relation r) {
        this.reindexRelation(r);
        this.fireEvent(new RelationMembersChangedEvent(this, r));
    }

    void fireNodeMoved(Node node, LatLon newCoor, EastNorth eastNorth) {
        this.reindexNode(node, newCoor, eastNorth);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive primitive, int oldChangesetId, int newChangesetId) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(primitive), oldChangesetId, newChangesetId));
    }

    void fireHighlightingChanged(OsmPrimitive primitive) {
        ++this.highlightUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDeletedPrimitives() {
        this.beginUpdate();
        try {
            if (this.cleanupDeleted(this.nodes.iterator()) | this.cleanupDeleted(this.ways.iterator()) | this.cleanupDeleted(this.relations.iterator())) {
                this.fireSelectionChanged();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupDeleted(Iterator<? extends OsmPrimitive> it) {
        boolean changed = false;
        Object object = this.selectionLock;
        synchronized (object) {
            while (it.hasNext()) {
                OsmPrimitive primitive = it.next();
                if (!primitive.isDeleted() || primitive.isVisible() && !primitive.isNew()) continue;
                this.selectedPrimitives.remove(primitive);
                this.selectionSnapshot = null;
                this.allPrimitives.remove(primitive);
                primitive.setDataset(null);
                changed = true;
                it.remove();
            }
            if (changed) {
                this.selectionSnapshot = null;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            this.clearSelection();
            for (OsmPrimitive primitive : this.allPrimitives) {
                primitive.setDataset(null);
            }
            this.nodes.clear();
            this.ways.clear();
            this.relations.clear();
            this.allPrimitives.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public void deleteInvisible() {
        for (OsmPrimitive primitive : this.allPrimitives) {
            if (primitive.isVisible()) continue;
            primitive.setDeleted(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdHash
    implements Hash<PrimitiveId, OsmPrimitive> {
        private IdHash() {
        }

        @Override
        public int getHashCode(PrimitiveId k) {
            return (int)k.getUniqueId() ^ k.getType().hashCode();
        }

        @Override
        public boolean equals(PrimitiveId key, OsmPrimitive value) {
            if (key == null || value == null) {
                return false;
            }
            return key.getUniqueId() == value.getUniqueId() && key.getType() == value.getType();
        }
    }
}

