/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static PrefixSuffixSwitcher[] prefixSuffixSwitchers = new PrefixSuffixSwitcher[]{new PrefixSuffixSwitcher("left", "right"), new PrefixSuffixSwitcher("forward", "backward"), new PrefixSuffixSwitcher("forwards", "backwards"), new PrefixSuffixSwitcher("up", "down"), new PrefixSuffixSwitcher("east", "west"), new PrefixSuffixSwitcher("north", "south")};
    private static ArrayList<String> reversibleTags = new ArrayList<String>(Arrays.asList("oneway", "incline", "direction"));

    public static boolean isReversible(Way way) {
        for (String key : way.keySet()) {
            if (reversibleTags.contains(key)) {
                return false;
            }
            for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                if (key.equals(prefixSuffixSwitcher.apply(key))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> ways) {
        ArrayList<Way> newWays = new ArrayList<Way>(ways);
        for (Way way : ways) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            newWays.remove(way);
        }
        return newWays;
    }

    public String invertNumber(String value) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        String sign = matcher.group(1);
        String rest = matcher.group(2);
        sign = sign.equals("-") ? "" : "-";
        return sign + rest;
    }

    @Override
    public Collection<Command> execute(Way oldway, Way way) throws UserCancelException {
        HashMap<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<TagCorrection> tagCorrections = new ArrayList<TagCorrection>();
        Iterator<String> i$ = way.keySet().iterator();
        while (i$.hasNext()) {
            boolean needsCorrection;
            String newValue;
            String value;
            String newKey;
            String key;
            block16: {
                block14: {
                    block15: {
                        newKey = key = i$.next();
                        newValue = value = way.get(key);
                        if (!key.equals("oneway")) break block14;
                        if (!OsmUtils.isReversed(value)) break block15;
                        newValue = "yes";
                        break block16;
                    }
                    if (!OsmUtils.isTrue(value)) break block16;
                    newValue = "-1";
                    break block16;
                }
                if (key.equals("incline") || key.equals("direction")) {
                    PrefixSuffixSwitcher switcher = new PrefixSuffixSwitcher("up", "down");
                    newValue = switcher.apply(value);
                    if (newValue.equals(value)) {
                        newValue = this.invertNumber(value);
                    }
                } else {
                    PrefixSuffixSwitcher prefixSuffixSwitcher;
                    PrefixSuffixSwitcher[] arr$ = prefixSuffixSwitchers;
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$ && key.equals(newKey = (prefixSuffixSwitcher = arr$[i$2]).apply(key)) && value.equals(newValue = prefixSuffixSwitcher.apply(value)); ++i$2) {
                    }
                }
            }
            boolean bl = needsCorrection = !key.equals(newKey);
            if (way.get(newKey) != null && way.get(newKey).equals(newValue)) {
                needsCorrection = false;
            }
            if (!value.equals(newValue)) {
                needsCorrection = true;
            }
            if (!needsCorrection) continue;
            tagCorrections.add(new TagCorrection(key, value, newKey, newValue));
        }
        if (!tagCorrections.isEmpty()) {
            tagCorrectionsMap.put(way, tagCorrections);
        }
        HashMap<OsmPrimitive, List<RoleCorrection>> roleCorrectionMap = new HashMap<OsmPrimitive, List<RoleCorrection>>();
        ArrayList<RoleCorrection> roleCorrections = new ArrayList<RoleCorrection>();
        List<OsmPrimitive> referrers = oldway.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            if (!(referrer instanceof Relation)) continue;
            Relation relation = (Relation)referrer;
            int position = 0;
            for (RelationMember member : relation.getMembers()) {
                if (!member.getMember().hasEqualSemanticAttributes(oldway) || !member.hasRole()) {
                    ++position;
                    continue;
                }
                boolean found = false;
                String newRole = null;
                for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                    newRole = prefixSuffixSwitcher.apply(member.getRole());
                    if (newRole.equals(member.getRole())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    roleCorrections.add(new RoleCorrection(relation, position, member, newRole));
                }
                ++position;
            }
        }
        if (!roleCorrections.isEmpty()) {
            roleCorrectionMap.put(way, roleCorrections);
        }
        return this.applyCorrections(tagCorrectionsMap, roleCorrectionMap, I18n.tr("When reversing this way, the following changes to properties of the way and its nodes are suggested in order to maintain data consistency."));
    }

    private static class PrefixSuffixSwitcher {
        private static final String SEPARATOR = "[:_]?";
        private final String a;
        private final String b;
        private final Pattern startPattern;
        private final Pattern endPattern;

        public PrefixSuffixSwitcher(String a, String b) {
            this.a = a;
            this.b = b;
            this.startPattern = Pattern.compile("^(" + a + "|" + b + ")(" + SEPARATOR + "|$)", 2);
            this.endPattern = Pattern.compile("^.*[:_]?(" + a + "|" + b + ")$", 2);
        }

        public String apply(String text) {
            Matcher m = this.startPattern.matcher(text);
            if (!m.lookingAt()) {
                m = this.endPattern.matcher(text);
            }
            if (m.lookingAt()) {
                String leftRight = m.group(1).toLowerCase();
                StringBuilder result = new StringBuilder();
                result.append(text.substring(0, m.start(1)));
                result.append(leftRight.equals(this.a) ? this.b : this.a);
                result.append(text.substring(m.end(1)));
                return result.toString();
            }
            return text;
        }
    }
}

