/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PurgePrimitivesCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(PurgePrimitivesCommand.class.getName());
    private Collection<OsmPrimitive> toPurge;
    private Set<OsmPrimitive> purgedPrimitives;
    private Map<OsmPrimitive, PrimitiveData> origVersionsOfTouchedPrimitives;

    protected void init(Collection<OsmPrimitive> toPurge) {
        this.toPurge = toPurge;
        this.purgedPrimitives = new HashSet<OsmPrimitive>();
        this.origVersionsOfTouchedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();
    }

    public PurgePrimitivesCommand(OsmPrimitive primitive) {
        this.init(Collections.singleton(primitive));
    }

    public PurgePrimitivesCommand(OsmDataLayer layer, OsmPrimitive primitive) {
        super(layer);
        this.init(Collections.singleton(primitive));
    }

    public PurgePrimitivesCommand(OsmDataLayer layer, Collection<OsmPrimitive> primitives) {
        super(layer);
        this.init(primitives);
    }

    public Collection<OsmPrimitive> getPurgedPrimitives() {
        return this.purgedPrimitives;
    }

    @Override
    public JLabel getDescription() {
        if (this.purgedPrimitives.size() == 1) {
            return new JLabel(I18n.tr("Purged object ''{0}''", this.purgedPrimitives.iterator().next().getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get("data", "object"), 0);
        }
        return new JLabel(I18n.trn("Purged {0} object", "Purged {0} objects", this.purgedPrimitives.size(), this.purgedPrimitives.size()));
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.purgedPrimitives.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osm : this.purgedPrimitives) {
            children.add(new PseudoCommand(){

                @Override
                public JLabel getDescription() {
                    return new JLabel(I18n.tr("Purged object ''{0}''", osm.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get("data", "object"), 0);
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osm);
                }
            });
        }
        return children;
    }

    protected void removeReferecesToPrimitive(OsmPrimitive child, Set<OsmPrimitive> hive) {
        hive.remove(child);
        for (OsmPrimitive parent : child.getReferrers()) {
            if (this.toPurge.contains(parent)) {
                return;
            }
            if (parent instanceof Way) {
                Way w = (Way)parent;
                if (!this.origVersionsOfTouchedPrimitives.containsKey(w)) {
                    this.origVersionsOfTouchedPrimitives.put(w, w.save());
                }
                w.removeNode((Node)child);
                if (w.getNodesCount() >= 2) continue;
                System.out.println(I18n.tr("Warning: Purging way {0} because number of nodes dropped below 2. Current is {1}", w.getId(), w.getNodesCount()));
                hive.add(w);
                continue;
            }
            if (!(parent instanceof Relation)) continue;
            Relation r = (Relation)parent;
            if (!this.origVersionsOfTouchedPrimitives.containsKey(r)) {
                this.origVersionsOfTouchedPrimitives.put(r, r.save());
            }
            System.out.println(I18n.tr("Removing reference from relation {0}", r.getId()));
            r.removeMembersFor(child);
        }
    }

    @Override
    public boolean executeCommand() {
        HashSet<OsmPrimitive> hive = new HashSet<OsmPrimitive>();
        hive.addAll(this.toPurge);
        while (!hive.isEmpty()) {
            OsmPrimitive p = (OsmPrimitive)hive.iterator().next();
            this.removeReferecesToPrimitive(p, hive);
            this.getLayer().data.removePrimitive(p);
            this.purgedPrimitives.add(p);
            ConflictCollection conflicts = this.getLayer().getConflicts();
            if (!conflicts.hasConflictForMy(p)) continue;
            this.rememberConflict(conflicts.getConflictForMy(p));
            conflicts.remove(p);
        }
        return super.executeCommand();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            logger.warning(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.getLayer().toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.getLayer());
        for (OsmPrimitive osmPrimitive : this.purgedPrimitives) {
            this.getLayer().data.addPrimitive(osmPrimitive);
        }
        for (Map.Entry entry : this.origVersionsOfTouchedPrimitives.entrySet()) {
            ((OsmPrimitive)entry.getKey()).load((PrimitiveData)entry.getValue());
        }
        this.reconstituteConflicts();
        super.undoCommand();
    }
}

