/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final String key;
    private final String value;

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> objects, String key, String value) {
        this.key = key;
        this.value = value;
        if (value == null) {
            for (OsmPrimitive osmPrimitive : objects) {
                if (osmPrimitive.get(key) == null) continue;
                this.objects.add(osmPrimitive);
            }
        } else {
            for (OsmPrimitive osmPrimitive : objects) {
                String val = osmPrimitive.get(key);
                if (val != null && value.equals(val)) continue;
                this.objects.add(osmPrimitive);
            }
        }
    }

    public ChangePropertyCommand(OsmPrimitive object, String key, String value) {
        this.key = key;
        this.value = value;
        String val = object.get(key);
        if (value == null && val != null || value != null && (val == null || !value.equals(val))) {
            this.objects.add(object);
        }
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (this.value == null) {
            for (OsmPrimitive osm : this.objects) {
                osm.setModified(true);
                osm.remove(this.key);
            }
        } else {
            for (OsmPrimitive osm : this.objects) {
                osm.setModified(true);
                osm.put(this.key, this.value);
            }
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    @Override
    public JLabel getDescription() {
        String text;
        if (this.objects.size() == 1) {
            OsmPrimitive primitive = this.objects.iterator().next();
            String msg = "";
            if (this.value == null) {
                switch (OsmPrimitiveType.from(primitive)) {
                    case NODE: {
                        msg = I18n.marktr("Remove \"{0}\" for node ''{1}''");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Remove \"{0}\" for way ''{1}''");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Remove \"{0}\" for relation ''{1}''");
                    }
                }
                text = I18n.tr(msg, this.key, primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                switch (OsmPrimitiveType.from(primitive)) {
                    case NODE: {
                        msg = I18n.marktr("Set {0}={1} for node ''{2}''");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Set {0}={1} for way ''{2}''");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Set {0}={1} for relation ''{2}''");
                    }
                }
                text = I18n.tr(msg, this.key, this.value, primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        } else {
            text = this.value == null ? I18n.tr("Remove \"{0}\" for {1} objects", this.key, this.objects.size()) : I18n.tr("Set {0}={1} for {2} objects", this.key, this.value, this.objects.size());
        }
        return new JLabel(text, ImageProvider.get("data", "key"), 0);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osm : this.objects) {
            children.add(new PseudoCommand(){

                @Override
                public JLabel getDescription() {
                    return new JLabel(osm.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osm)), 0);
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osm);
                }
            });
        }
        return children;
    }
}

