/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class MapMode
extends JosmAction
implements MouseListener,
MouseMotionListener {
    private final Cursor cursor;
    private Cursor oldCursor;

    public MapMode(String name, String iconName, String tooltip, Shortcut shortcut, MapFrame mapFrame, Cursor cursor) {
        super(name, "mapmode/" + iconName, tooltip, shortcut, false);
        this.cursor = cursor;
        this.putValue("active", false);
    }

    public MapMode(String name, String iconName, String tooltip, MapFrame mapFrame, Cursor cursor) {
        this.putValue("Name", name);
        this.putValue("SmallIcon", ImageProvider.get("mapmode", iconName));
        this.putValue("ShortDescription", tooltip);
        this.cursor = cursor;
    }

    public void enterMode() {
        this.putValue("active", true);
        this.oldCursor = Main.map.mapView.getCursor();
        Main.map.mapView.setCursor(this.cursor);
        this.updateStatusLine();
    }

    public void exitMode() {
        this.putValue("active", false);
        Main.map.mapView.setCursor(this.oldCursor);
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.getModeHelpText());
        Main.map.statusLine.repaint();
    }

    public String getModeHelpText() {
        return "";
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.map != null) {
            Main.map.selectMapMode(this);
        }
    }

    public boolean layerIsSupported(Layer l) {
        return true;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }
}

