/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.audio;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AudioFastSlowAction
extends JosmAction {
    private double multiplier = Main.pref.getDouble("audio.fastfwdmultiplier", "1.3");

    public AudioFastSlowAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean fast) {
        super(name, iconName, tooltip, shortcut, true);
        if (!fast) {
            this.multiplier = 1.0 / this.multiplier;
        }
    }

    public void actionPerformed(ActionEvent e) {
        double speed = AudioPlayer.speed();
        if (speed * this.multiplier <= 0.1) {
            return;
        }
        try {
            if (AudioPlayer.playing() || AudioPlayer.paused()) {
                AudioPlayer.play(AudioPlayer.url(), AudioPlayer.position(), speed * this.multiplier);
            }
        }
        catch (Exception ex) {
            AudioPlayer.audioMalfunction(ex);
        }
    }
}

