/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction
implements MouseListener {
    private JTextField url = new JTextField();
    private JTextField lat = new JTextField();
    private JTextField lon = new JTextField();
    private JTextField zm = new JTextField();
    private double zoomFactor = 0.0;

    public JumpToAction() {
        super(I18n.tr("Jump To Position"), null, I18n.tr("Opens a dialog that allows to jump to a specific location"), Shortcut.registerShortcut("tools:jumpto", I18n.tr("Tool: {0}", I18n.tr("Jump To Position")), 71, 1), true);
    }

    public void showJumpToDialog() {
        MapView mv = Main.map.mapView;
        if (mv == null) {
            return;
        }
        LatLon curPos = mv.getProjection().eastNorth2latlon(mv.getCenter());
        this.lat.setText(Double.toString(curPos.lat()));
        this.lon.setText(Double.toString(curPos.lon()));
        double dist = mv.getDist100Pixel();
        this.zoomFactor = 1.0 / dist;
        this.zm.setText(Long.toString(Math.round(dist * 100.0) / 100L));
        this.updateUrl(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html>" + I18n.tr("Enter Lat/Lon to jump to position.") + "<br>" + I18n.tr("You can also paste an URL from www.openstreetmap.org") + "<br>" + "</html>"), "North");
        class OsmLonLatListener
        implements DocumentListener {
            OsmLonLatListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }

            public void insertUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }

            public void removeUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }
        }
        OsmLonLatListener x = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(x);
        this.lon.getDocument().addDocumentListener(x);
        this.zm.getDocument().addDocumentListener(x);
        class OsmURLListener
        implements DocumentListener {
            OsmURLListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }

            public void insertUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }

            public void removeUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }
        }
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "North");
        p.add((Component)new JLabel(I18n.tr("Latitude")), GBC.eol());
        p.add((Component)this.lat, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("Longitude")), GBC.eol());
        p.add((Component)this.lon, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("Zoom (in metres)")), GBC.eol());
        p.add((Component)this.zm, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("URL")), GBC.eol());
        p.add((Component)this.url, GBC.eol().fill(2));
        Object[] buttons = new Object[]{I18n.tr("Jump there"), I18n.tr("Cancel")};
        LatLon ll = null;
        double zoomLvl = 100.0;
        while (ll == null) {
            int option = JOptionPane.showOptionDialog(Main.parent, panel, I18n.tr("Jump to Position"), 2, -1, null, buttons, buttons[0]);
            if (option != 0) {
                return;
            }
            try {
                zoomLvl = Double.parseDouble(this.zm.getText());
                ll = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse Latitude, Longitude or Zoom. Please check."), I18n.tr("Unable to parse Lon/Lat"), 0);
            }
        }
        mv.zoomToFactor(mv.getProjection().latlon2eastNorth(ll), this.zoomFactor * zoomLvl);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        Bounds b = OsmUrlToBounds.parse(this.url.getText());
        if (b != null) {
            String[] args;
            this.lat.setText(Double.toString((b.getMin().lat() + b.getMax().lat()) / 2.0));
            this.lon.setText(Double.toString((b.getMin().lon() + b.getMax().lon()) / 2.0));
            int zoomLvl = 16;
            for (String arg : args = this.url.getText().substring(this.url.getText().indexOf(63) + 1).split("&")) {
                int eq = arg.indexOf(61);
                if (eq == -1 || !arg.substring(0, eq).equalsIgnoreCase("zoom")) continue;
                zoomLvl = Integer.parseInt(arg.substring(eq + 1));
                break;
            }
            this.zm.setText(Double.toString(Math.round(1.0E7 * Math.pow(2.0, -1 * zoomLvl))));
        }
    }

    private void updateUrl(boolean force) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || force)) {
            return;
        }
        try {
            double dlat = Double.parseDouble(this.lat.getText());
            double dlon = Double.parseDouble(this.lon.getText());
            double m = Double.parseDouble(this.zm.getText());
            int zoomLvl = 18;
            if (m > 0.0) {
                zoomLvl = (int)Math.round(-1.0 * Math.log(m / 1.0E7) / Math.log(2.0));
            }
            int decimals = (int)Math.pow(10.0, zoomLvl / 3);
            dlat = Math.round(dlat * (double)decimals);
            dlon = Math.round(dlon * (double)decimals);
            this.url.setText("http://www.openstreetmap.org/?lat=" + (dlat /= (double)decimals) + "&lon=" + (dlon /= (double)decimals) + "&zoom=" + zoomLvl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.showJumpToDialog();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.showJumpToDialog();
    }
}

