/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference.providers;

import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntFileReferenceSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntFileReferenceProvider
extends PsiReferenceProvider {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntFileReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntFileReferenceProvider.getReferencesByElement must not be null");
        }
        AntStructuredElement antElement = (AntStructuredElement)element;
        List<String> referenceAttributes = antElement.getFileReferenceAttributes();
        if (referenceAttributes.isEmpty()) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntFileReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        ArrayList<FileReference> refList = new ArrayList<FileReference>();
        for (String attrib : referenceAttributes) {
            String attrValue;
            XmlAttributeValue xmlAttributeValue;
            XmlAttribute attr = antElement.getSourceElement().getAttribute(attrib, null);
            if (attr == null || (xmlAttributeValue = attr.getValueElement()) == null || (attrValue = attr.getValue()) == null || attrValue.length() == 0 || AntFileReferenceProvider.isSingleSlash(attrValue) || attrValue.indexOf("@{") >= 0) continue;
            AntFileReferenceSet refSet = new AntFileReferenceSet(antElement, xmlAttributeValue, this);
            refList.addAll(Arrays.asList(refSet.getAllReferences()));
        }
        psiReferenceArray = refList.toArray(new PsiReference[refList.size()]);
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntFileReferenceProvider.getReferencesByElement must not return null");
    }

    private static boolean isSingleSlash(String attrValue) {
        return "/".equals(attrValue) || "\\".equals(attrValue);
    }
}

