/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.lang.ant.psi.AntAllTasksContainer;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntMacroDef;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntGenericReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringSetSpinAllocator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntMacroDefParameterReference
extends AntGenericReference {
    private final XmlElement myXmlElement;

    public AntMacroDefParameterReference(AntElement antElement, String str, TextRange textRange, XmlElement xmlElement) {
        super(antElement, str, textRange, null);
        this.myXmlElement = xmlElement;
    }

    @Override
    @Nullable
    public String getCanonicalText() {
        AntStructuredElement se;
        String text = super.getCanonicalText();
        if (text.indexOf("${") >= 0 && (se = (AntStructuredElement)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), AntStructuredElement.class, (boolean)true)) != null) {
            text = se.computeAttributeValue(text);
        }
        return text;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        AntElement element = this.getElement();
        String oldName = this.getCanonicalText();
        if (oldName != null && !oldName.equals(newElementName)) {
            if (this.myXmlElement instanceof XmlAttributeValue) {
                String text = this.myXmlElement.getText();
                if (text.length() > 2) {
                    ((XmlAttribute)this.myXmlElement.getParent()).setValue(text.substring(1, text.length() - 1).replace("@{" + oldName + '}', "@{" + newElementName + '}'));
                }
            } else {
                XmlTagValue tagValue = ((XmlTag)this.myXmlElement).getValue();
                tagValue.setText(tagValue.getText().replace("@{" + oldName + '}', "@{" + newElementName + '}'));
            }
        }
        return element;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/AntMacroDefParameterReference.bindToElement must not be null");
        }
        return this.handleElementRename(((PsiNamedElement)element).getName());
    }

    @Override
    public PsiElement resolveInner() {
        String name;
        AntMacroDef macrodef = (AntMacroDef)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), AntMacroDef.class, (boolean)true);
        if (macrodef != null && (name = this.getCanonicalText()) != null) {
            for (PsiElement child : macrodef.getChildren()) {
                if (!(child instanceof AntStructuredElement) || child instanceof AntAllTasksContainer || !name.equals(((AntStructuredElement)child).getName())) continue;
                return child;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object[] getVariants() {
        Set variants = StringSetSpinAllocator.alloc();
        try {
            int count;
            AntMacroDef macrodef = (AntMacroDef)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), AntMacroDef.class, (boolean)true);
            if (macrodef != null) {
                for (PsiElement child : macrodef.getChildren()) {
                    AntStructuredElement element;
                    if (!(child instanceof AntStructuredElement) || !(element = (AntStructuredElement)child).getSourceElement().getName().equals("attribute")) continue;
                    variants.add(element.getName());
                }
            }
            Object[] objectArray = (count = variants.size()) == 0 ? EMPTY_ARRAY : variants.toArray(new String[count]);
            if (objectArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntMacroDefParameterReference.getVariants must not return null");
            }
            return objectArray;
        }
        finally {
            StringSetSpinAllocator.dispose((Set)variants);
        }
    }
}

