/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.lang.ant.psi.AntAnt;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntImport;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.AntTypeDef;
import com.intellij.lang.ant.psi.impl.reference.AntFileReference;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntFileReferenceSet
extends FileReferenceSet {
    private final XmlAttributeValue myValue;

    public AntFileReferenceSet(AntStructuredElement element, XmlAttributeValue value, PsiReferenceProvider provider) {
        super(AntFileReferenceSet.cutTrailingSlash(FileUtil.toSystemIndependentName((String)StringUtil.stripQuotesAroundValue((String)value.getText()))), (PsiElement)element, value.getTextRange().getStartOffset() - element.getTextRange().getStartOffset() + 1, provider, SystemInfo.isFileSystemCaseSensitive);
        this.myValue = value;
    }

    private static String cutTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected boolean isSoft() {
        AntStructuredElement element = this.getElement();
        if (!(element instanceof AntImport || element instanceof AntTypeDef || element instanceof AntProperty || element instanceof AntAnt)) {
            return true;
        }
        if (element instanceof AntProperty) {
            return ((AntProperty)element).getFileName() != null;
        }
        return false;
    }

    public AntFileReference createFileReference(TextRange range, int index, String text) {
        return new AntFileReference(this, range, index, text);
    }

    public AntStructuredElement getElement() {
        return (AntStructuredElement)super.getElement();
    }

    @Nullable
    public String getPathString() {
        return this.getElement().computeAttributeValue(super.getPathString());
    }

    public boolean isAbsolutePathReference() {
        if (super.isAbsolutePathReference()) {
            return true;
        }
        String pathString = this.getPathString();
        if (SystemInfo.isWindows && pathString.length() == 2 && Character.isLetter(pathString.charAt(0)) && pathString.charAt(1) == ':') {
            return true;
        }
        return FileUtil.isAbsolute((String)pathString);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        Set<PsiDirectory> set;
        AntStructuredElement element = this.getElement();
        AntFile antFile = element.getAntFile();
        if (antFile != null) {
            PsiDirectory directory;
            void var3_7;
            VirtualFile virtualFile = antFile.getContainingPath();
            if (this.isAbsolutePathReference()) {
                if (SystemInfo.isWindows) {
                    NewVirtualFile newVirtualFile = ManagingFS.getInstance().findRoot("", (NewVirtualFileSystem)LocalFileSystem.getInstance());
                } else {
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath("/");
                }
            } else if (!(element instanceof AntImport)) {
                String basedir = element.computeAttributeValue("${basedir}");
                assert (basedir != null);
                VirtualFile virtualFile3 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)basedir));
            }
            if (var3_7 != null && (directory = antFile.getViewProvider().getManager().findDirectory((VirtualFile)var3_7)) != null) {
                set = Collections.singleton(directory);
                if (set == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntFileReferenceSet.computeDefaultContexts must not return null");
                return set;
            }
        }
        if ((set = super.computeDefaultContexts()) != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntFileReferenceSet.computeDefaultContexts must not return null");
    }

    XmlAttributeValue getManipulatorElement() {
        return this.myValue;
    }
}

