/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.impl.AllJarsUnderDirEntry;
import com.intellij.lang.ant.config.impl.SinglePathEntry;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.PathUtil;
import com.intellij.util.config.Externalizer;
import java.io.File;
import java.util.List;
import org.jdom.Element;

public interface AntClasspathEntry {
    public static final Externalizer<AntClasspathEntry> EXTERNALIZER = new Externalizer<AntClasspathEntry>(){

        public AntClasspathEntry readValue(Element dataElement) throws InvalidDataException {
            String pathUrl = dataElement.getAttributeValue("path");
            if (pathUrl != null) {
                return new SinglePathEntry(PathUtil.toPresentableUrl((String)pathUrl));
            }
            String dirUrl = dataElement.getAttributeValue("dir");
            if (dirUrl != null) {
                return new AllJarsUnderDirEntry(PathUtil.toPresentableUrl((String)dirUrl));
            }
            throw new InvalidDataException();
        }

        public void writeValue(Element dataElement, AntClasspathEntry entry) throws WriteExternalException {
            entry.writeExternal(dataElement);
        }
    };

    public String getPresentablePath();

    public void writeExternal(Element var1) throws WriteExternalException;

    public void addFilesTo(List<File> var1);

    public CompositeAppearance getAppearance();
}

