/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.execution.RunManagerEx;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.impl.AntBeforeRunTask;
import com.intellij.lang.ant.config.impl.AntBeforeRunTaskProvider;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CellAppearance;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.awt.Color;
import java.util.ArrayList;

final class AntTargetNodeDescriptor
extends AntNodeDescriptor {
    private static final TextAttributes ourPostfixAttributes = new TextAttributes(new Color(128, 0, 0), null, null, EffectType.BOXED, 0);
    private final AntBuildTargetBase myTarget;
    private CompositeAppearance myHighlightedText;

    public AntTargetNodeDescriptor(Project project, NodeDescriptor parentDescriptor, AntBuildTargetBase target) {
        super(project, parentDescriptor);
        this.myTarget = target;
        this.myHighlightedText = new CompositeAppearance();
    }

    public Object getElement() {
        return this.myTarget;
    }

    public AntBuildTargetBase getTarget() {
        return this.myTarget;
    }

    public boolean update() {
        CompositeAppearance oldText = this.myHighlightedText;
        boolean isMeta = this.myTarget instanceof MetaTarget;
        this.myClosedIcon = isMeta ? Icons.ANT_META_TARGET_ICON : Icons.ANT_TARGET_ICON;
        this.myOpenIcon = this.myClosedIcon;
        this.myHighlightedText = new CompositeAppearance();
        AntBuildFile buildFile = isMeta ? ((MetaTarget)this.myTarget).getBuildFile() : this.myTarget.getModel().getBuildFile();
        Color color = buildFile.isTargetVisible(this.myTarget) ? Color.black : Color.gray;
        TextAttributes nameAttributes = new TextAttributes(color, null, null, EffectType.BOXED, this.myTarget.isDefault() ? 1 : 0);
        this.myHighlightedText.getEnding().addText(this.myTarget.getDisplayName(), nameAttributes);
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(this.myProject);
        ArrayList<String> addedNames = new ArrayList<String>(4);
        for (ExecutionEvent event : antConfiguration.getEventsForTarget(this.myTarget)) {
            String presentableName;
            if (event instanceof ExecuteCompositeTargetEvent) {
                presentableName = ((ExecuteCompositeTargetEvent)event).getMetaTargetName();
                if (presentableName.equals(this.myTarget.getName())) {
                    continue;
                }
            } else {
                presentableName = event.getPresentableName();
            }
            if (addedNames.contains(presentableName)) continue;
            addedNames.add(presentableName);
            this.myHighlightedText.getEnding().addText(" (" + presentableName + ')', ourPostfixAttributes);
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        VirtualFile vFile = buildFile.getVirtualFile();
        if (vFile != null) {
            for (AntBeforeRunTask task : runManager.getBeforeRunTasks(AntBeforeRunTaskProvider.ID, true)) {
                if (!task.isRunningTarget(this.myTarget)) continue;
                this.myHighlightedText.getEnding().addText(" (Before Run/Debug)", ourPostfixAttributes);
                break;
            }
        }
        this.myName = this.myHighlightedText.getText();
        AntBuildTargetBase target = this.getTarget();
        if (!this.addShortcutText(target.getActionId()) && target.isDefault()) {
            this.addShortcutText(((AntBuildModelBase)target.getModel()).getDefaultTargetActionId());
        }
        return !Comparing.equal((Object)this.myHighlightedText, (Object)oldText);
    }

    private boolean addShortcutText(String actionId) {
        return AntTargetNodeDescriptor.addShortcutText(actionId, this.myHighlightedText);
    }

    public static boolean addShortcutText(String actionId, CompositeAppearance appearance) {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts(actionId);
        if (shortcuts != null && shortcuts.length > 0) {
            appearance.getEnding().addText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return true;
        }
        return false;
    }

    public CellAppearance getHighlightedText() {
        return this.myHighlightedText;
    }

    @Override
    public boolean isAutoExpand() {
        return false;
    }

    @Override
    public void customize(SimpleColoredComponent component) {
        this.getHighlightedText().customize(component);
        component.setIcon(this.getOpenIcon());
        String toolTipText = this.getTarget().getNotEmptyDescription();
        component.setToolTipText(toolTipText);
    }
}

