/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtilEx {
    private static final PsiConstantEvaluationHelperImpl CONSTANT_EVALUATION_HELPER = new PsiConstantEvaluationHelperImpl();

    private AnnotationUtilEx() {
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatedElementFor(@Nullable PsiElement element, LookupType type) {
        while (element != null) {
            PsiElement e;
            if ((type == LookupType.PREFER_DECLARATION || type == LookupType.DECLRARATION_ONLY) && element instanceof PsiReferenceExpression) {
                PsiElement e2 = ((PsiReferenceExpression)element).resolve();
                if (e2 instanceof PsiModifierListOwner) {
                    return (PsiModifierListOwner)e2;
                }
                if (type == LookupType.DECLRARATION_ONLY) {
                    return null;
                }
            }
            element = ContextComputationProcessor.getTopLevelInjectionTarget(element);
            PsiElement parent = element.getParent();
            if (element instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getOperationSign().getTokenType() == JavaTokenType.PLUSEQ) {
                element = ((PsiAssignmentExpression)element).getLExpression();
                continue;
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression p = (PsiAssignmentExpression)parent;
                if (p.getRExpression() == element) {
                    element = p.getLExpression();
                    continue;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod m = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                if (m != null) {
                    return m;
                }
            } else {
                if (parent instanceof PsiModifierListOwner) {
                    return (PsiModifierListOwner)parent;
                }
                if (parent instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue value = (PsiArrayInitializerMemberValue)parent;
                    PsiElement pair = value.getParent();
                    if (pair instanceof PsiNameValuePair) {
                        return AnnotationUtilEx.getAnnotationMethod((PsiNameValuePair)pair, element);
                    }
                } else {
                    if (parent instanceof PsiNameValuePair) {
                        return AnnotationUtilEx.getAnnotationMethod((PsiNameValuePair)parent, element);
                    }
                    return PsiUtilEx.getParameterForArgument(element);
                }
            }
            if (type != LookupType.DECLRARATION_ONLY && element instanceof PsiReferenceExpression && (e = ((PsiReferenceExpression)element).resolve()) instanceof PsiModifierListOwner) {
                return (PsiModifierListOwner)e;
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiModifierListOwner getAnnotationMethod(PsiNameValuePair pair, PsiElement element) {
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(fqn, element.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name = pair.getName();
            PsiMethod[] methods = psiClass.findMethodsByName(name != null ? name : "value", false);
            return methods.length > 0 ? methods[0] : null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotation[] getAnnotationFrom(PsiModifierListOwner owner, Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect, boolean inHierarchy) {
        PsiAnnotation directAnnotation;
        PsiAnnotation[] psiAnnotationArray;
        if (!PsiUtilEx.isLanguageAnnotationTarget(owner)) {
            psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
            if (PsiAnnotation.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotationFrom must not return null");
            return psiAnnotationArray;
        }
        PsiAnnotation psiAnnotation = directAnnotation = inHierarchy ? AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner, (Set)((Set)annotationName.second)) : AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Set)((Set)annotationName.second));
        if (directAnnotation != null) {
            psiAnnotationArray = new PsiAnnotation[]{directAnnotation};
            if (psiAnnotationArray == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotationFrom must not return null");
            return psiAnnotationArray;
        }
        if (allowIndirect) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = AnnotationUtilEx.getAnnotations(owner, inHierarchy)) {
                PsiAnnotation psiAnnotation2;
                PsiElement resolved;
                PsiJavaCodeReferenceElement nameReference = annotation.getNameReferenceElement();
                if (nameReference == null || !((resolved = nameReference.resolve()) instanceof PsiClass) || (psiAnnotation2 = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)resolved), (Set)((Set)annotationName.second))) == null) continue;
                psiAnnotationArray = new PsiAnnotation[]{psiAnnotation2, annotation};
                if (psiAnnotationArray == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotationFrom must not return null");
                return psiAnnotationArray;
            }
        }
        psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
        if (PsiAnnotation.EMPTY_ARRAY != null) return psiAnnotationArray;
        throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotationFrom must not return null");
    }

    public static PsiAnnotation[] getAnnotationFrom(@NotNull PsiModifierListOwner owner, @NotNull Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotationFrom must not be null");
        }
        if (annotationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotationFrom must not be null");
        }
        return AnnotationUtilEx.getAnnotationFrom(owner, annotationName, allowIndirect, true);
    }

    @Nullable
    public static String calcAnnotationValue(PsiAnnotation[] annotation, @NonNls String attr) {
        for (PsiAnnotation psiAnnotation : annotation) {
            String value = AnnotationUtilEx.calcAnnotationValue(psiAnnotation, attr);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static String calcAnnotationValue(@NotNull PsiAnnotation annotation, @NonNls String attr) {
        Object o;
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/util/AnnotationUtilEx.calcAnnotationValue must not be null");
        }
        PsiAnnotationMemberValue value = annotation.findAttributeValue(attr);
        if (value instanceof PsiExpression && (o = CONSTANT_EVALUATION_HELPER.computeConstantExpression((PsiElement)value)) instanceof String) {
            return (String)o;
        }
        return null;
    }

    private static PsiAnnotation[] getAnnotations(@NotNull PsiModifierListOwner listOwner, boolean inHierarchy) {
        PsiParameter parameter;
        PsiElement declarationScope;
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/util/AnnotationUtilEx.getAnnotations must not be null");
        }
        PsiModifierList modifierList = listOwner.getModifierList();
        if (modifierList == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        if (!inHierarchy) {
            return modifierList.getAnnotations();
        }
        final HashSet<PsiAnnotation> all = new HashSet<PsiAnnotation>(){

            @Override
            public boolean add(PsiAnnotation o) {
                return !this.contains(o) && super.add(o);
            }
        };
        if (listOwner instanceof PsiMethod) {
            all.addAll(Arrays.asList(modifierList.getAnnotations()));
            SuperMethodsSearch.search((PsiMethod)((PsiMethod)listOwner), null, (boolean)true, (boolean)true).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

                public boolean process(MethodSignatureBackedByPsiMethod superMethod) {
                    all.addAll(Arrays.asList(superMethod.getMethod().getModifierList().getAnnotations()));
                    return true;
                }
            });
            return all.toArray(new PsiAnnotation[all.size()]);
        }
        if (listOwner instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)listOwner).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameterList parameterList = ((PsiMethod)declarationScope).getParameterList();
            if (parameter.getParent() == parameterList) {
                PsiMethod method = (PsiMethod)declarationScope;
                final int parameterIndex = parameterList.getParameterIndex(parameter);
                all.addAll(Arrays.asList(modifierList.getAnnotations()));
                SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)true).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

                    public boolean process(MethodSignatureBackedByPsiMethod superMethod) {
                        PsiParameter superParameter = superMethod.getMethod().getParameterList().getParameters()[parameterIndex];
                        PsiModifierList modifierList = superParameter.getModifierList();
                        if (modifierList != null) {
                            all.addAll(Arrays.asList(modifierList.getAnnotations()));
                        }
                        return true;
                    }
                });
                return all.toArray(new PsiAnnotation[all.size()]);
            }
        }
        return modifierList.getAnnotations();
    }

    public static enum LookupType {
        PREFER_CONTEXT,
        PREFER_DECLARATION,
        CONTEXT_ONLY,
        DECLRARATION_ONLY;

    }
}

