/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import git4idea.config.GitVcsApplicationSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(id="ws", file="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State> {
    private static final SshExecutable DEFAULT_SSH = SshExecutable.IDEA_SSH;
    private final GitVcsApplicationSettings myAppSettings;
    private String myGitExecutable;
    private List<String> myCommitAuthors = new ArrayList<String>();
    public static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private boolean myCheckoutIncludesTags = false;
    private SshExecutable mySshExecutable = DEFAULT_SSH;
    public boolean UPDATE_STASH = true;
    private UpdateType myUpdateType = UpdateType.BRANCH_DEFAULT;
    private ConversionPolicy myLineSeparatorsConversion = ConversionPolicy.PROJECT_LINE_SEPARATORS;
    private boolean myAskBeforeLineSeparatorConversion = true;

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
        this.myGitExecutable = this.myAppSettings.defaultGit();
    }

    public boolean isStashOnUpdate() {
        return this.UPDATE_STASH;
    }

    public void setUpdateStash(boolean value) {
        this.UPDATE_STASH = value;
    }

    public boolean askBeforeLineSeparatorConversion() {
        return this.myAskBeforeLineSeparatorConversion;
    }

    public void setAskBeforeLineSeparatorConversion(boolean askBeforeLineSeparatorConversion) {
        this.myAskBeforeLineSeparatorConversion = askBeforeLineSeparatorConversion;
    }

    public ConversionPolicy getLineSeparatorsConversion() {
        return this.myLineSeparatorsConversion;
    }

    public void setLineSeparatorsConversion(ConversionPolicy lineSeparatorsConversion) {
        this.myLineSeparatorsConversion = lineSeparatorsConversion;
    }

    public UpdateType getUpdateType() {
        return this.myUpdateType;
    }

    public void setUpdateType(UpdateType updateType) {
        this.myUpdateType = updateType;
    }

    public boolean isCheckoutIncludesTags() {
        return this.myCheckoutIncludesTags;
    }

    public void setCheckoutIncludesTags(boolean value) {
        this.myCheckoutIncludesTags = value;
    }

    public void setGitExecutable(String path) {
        this.myGitExecutable = path;
        this.myAppSettings.setPathToGit(path);
    }

    public String getGitExecutable() {
        return this.myGitExecutable;
    }

    public void saveCommitAuthor(String author) {
        this.myCommitAuthors.remove(author);
        while (this.myCommitAuthors.size() >= 16) {
            this.myCommitAuthors.remove(this.myCommitAuthors.size() - 1);
        }
        this.myCommitAuthors.add(0, author);
    }

    public String[] getCommitAuthors() {
        return this.myCommitAuthors.toArray(new String[this.myCommitAuthors.size()]);
    }

    public State getState() {
        State s = new State();
        s.CHECKOUT_INCLUDE_TAGS = this.myCheckoutIncludesTags;
        s.GIT_EXECUTABLE = this.myGitExecutable;
        s.LINE_SEPARATORS_CONVERSION = this.myLineSeparatorsConversion;
        s.LINE_SEPARATORS_CONVERSION_ASK = this.myAskBeforeLineSeparatorConversion;
        s.PREVIOUS_COMMIT_AUTHORS = this.getCommitAuthors();
        s.SSH_EXECUTABLE = this.mySshExecutable;
        s.UPDATE_STASH = this.UPDATE_STASH;
        s.UPDATE_TYPE = this.myUpdateType;
        return s;
    }

    public void loadState(State s) {
        this.myCheckoutIncludesTags = s.CHECKOUT_INCLUDE_TAGS == null ? false : s.CHECKOUT_INCLUDE_TAGS;
        this.myGitExecutable = s.GIT_EXECUTABLE == null ? this.myAppSettings.defaultGit() : s.GIT_EXECUTABLE;
        this.myLineSeparatorsConversion = s.LINE_SEPARATORS_CONVERSION;
        this.myAskBeforeLineSeparatorConversion = s.LINE_SEPARATORS_CONVERSION_ASK;
        this.myCommitAuthors.clear();
        this.myCommitAuthors.addAll(Arrays.asList(s.PREVIOUS_COMMIT_AUTHORS));
        this.UPDATE_STASH = s.UPDATE_STASH;
        this.mySshExecutable = s.SSH_EXECUTABLE;
        this.myUpdateType = s.UPDATE_TYPE;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)ServiceManager.getService((Project)project, GitVcsSettings.class);
    }

    public boolean isIdeaSsh() {
        return (this.mySshExecutable == null ? DEFAULT_SSH : this.mySshExecutable) == SshExecutable.IDEA_SSH;
    }

    public static boolean isDefaultIdeaSsh() {
        return DEFAULT_SSH == SshExecutable.IDEA_SSH;
    }

    public void setIdeaSsh(boolean value) {
        this.mySshExecutable = value ? SshExecutable.IDEA_SSH : SshExecutable.NATIVE_SSH;
    }

    static /* synthetic */ SshExecutable access$000() {
        return DEFAULT_SSH;
    }

    public static enum ConversionPolicy {
        NONE,
        PROJECT_LINE_SEPARATORS;

    }

    public static enum UpdateType {
        BRANCH_DEFAULT,
        MERGE,
        REBASE;

    }

    public static enum SshExecutable {
        IDEA_SSH,
        NATIVE_SSH;

    }

    public static class State {
        public String GIT_EXECUTABLE;
        public String[] PREVIOUS_COMMIT_AUTHORS = new String[0];
        public Boolean CHECKOUT_INCLUDE_TAGS;
        public SshExecutable SSH_EXECUTABLE = GitVcsSettings.access$000();
        public boolean UPDATE_STASH = true;
        public UpdateType UPDATE_TYPE = UpdateType.BRANCH_DEFAULT;
        public ConversionPolicy LINE_SEPARATORS_CONVERSION = ConversionPolicy.PROJECT_LINE_SEPARATORS;
        public boolean LINE_SEPARATORS_CONVERSION_ASK = true;
    }
}

