/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.ide.passwordSafe.ui.PasswordSafePromptDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitSSHService;

public class GitSSHGUIHandler
implements GitSSHService.Handler {
    private final Project myProject;

    public GitSSHGUIHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, String fingerprint, boolean isNew) {
        final String message = isNew ? GitBundle.message("ssh.new.host.key", hostname, port, fingerprint, serverHostKeyAlgorithm) : GitBundle.message("ssh.changed.host.key", hostname, port, fingerprint, serverHostKeyAlgorithm);
        final AtomicBoolean rc = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                rc.set(0 == Messages.showYesNoDialog((Project)GitSSHGUIHandler.this.myProject, (String)message, (String)GitBundle.getString("ssh.confirm.key.titile"), null));
            }
        });
        return rc.get();
    }

    @Override
    public String askPassphrase(String username, String keyPath, boolean resetPassword, String lastError) {
        String error = this.processLastError(resetPassword, lastError);
        return PasswordSafePromptDialog.askPassphrase((Project)this.myProject, (String)GitBundle.getString("ssh.ask.passphrase.title"), (String)GitBundle.message("ssh.askPassphrase.message", keyPath, username), GitSSHGUIHandler.class, (String)("PASSPHRASE:" + keyPath), (boolean)resetPassword, (String)error);
    }

    @Nullable
    private String processLastError(boolean resetPassword, final String lastError) {
        String error;
        if (lastError != null && lastError.length() != 0 && !resetPassword) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GitSSHGUIHandler.this.showError(lastError);
                }
            });
            error = null;
        } else {
            error = lastError != null && lastError.length() == 0 ? null : lastError;
        }
        return error;
    }

    private void showError(String lastError) {
        if (lastError.length() != 0) {
            Messages.showErrorDialog((Project)this.myProject, (String)lastError, (String)GitBundle.getString("ssh.error.title"));
        }
    }

    @Override
    public Vector<String> replyToChallenge(final String username, final String name, final String instruction, final int numPrompts, final Vector<String> prompt, final Vector<Boolean> echo, final String lastError) {
        final AtomicReference rc = new AtomicReference();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GitSSHGUIHandler.this.showError(lastError);
                    GitSSHKeyboardInteractiveDialog dialog = new GitSSHKeyboardInteractiveDialog(name, numPrompts, instruction, prompt, echo, username);
                    dialog.show();
                    if (dialog.isOK()) {
                        rc.set(dialog.getResults());
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException("dialog failed", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("dialog failed", e);
        }
        return (Vector)rc.get();
    }

    @Override
    public String askPassword(String username, boolean resetPassword, String lastError) {
        String error = this.processLastError(resetPassword, lastError);
        return PasswordSafePromptDialog.askPassword((Project)this.myProject, (String)GitBundle.getString("ssh.password.title"), (String)GitBundle.message("ssh.password.message", username), GitSSHGUIHandler.class, (String)("PASSWORD:" + username), (boolean)resetPassword, (String)error);
    }

    private class GitSSHKeyboardInteractiveDialog
    extends DialogWrapper {
        JTextComponent[] inputs;
        JPanel contents;
        private final int myNumPrompts;
        private final String myInstruction;
        private final Vector<String> myPrompt;
        private final Vector<Boolean> myEcho;
        private final String myUserName;

        public GitSSHKeyboardInteractiveDialog(String name, int numPrompts, String instruction, Vector<String> prompt, Vector<Boolean> echo, String userName) {
            super(GitSSHGUIHandler.this.myProject, true);
            this.myNumPrompts = numPrompts;
            this.myInstruction = instruction;
            this.myPrompt = prompt;
            this.myEcho = echo;
            this.myUserName = userName;
            this.setTitle(GitBundle.message("ssh.keyboard.interactive.title", name));
            this.init();
            this.setResizable(true);
            this.setModal(true);
        }

        protected JComponent createCenterPanel() {
            if (this.contents == null) {
                GridBagConstraints c;
                int line = 0;
                this.contents = new JPanel(new GridBagLayout());
                this.inputs = new JTextComponent[this.myNumPrompts];
                Insets insets = new Insets(1, 1, 1, 1);
                if (this.myInstruction.length() != 0) {
                    JLabel instructionLabel = new JLabel(this.myInstruction);
                    c = new GridBagConstraints();
                    c.insets = insets;
                    c.gridx = 0;
                    c.gridy = line++;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 17;
                    this.contents.add((Component)instructionLabel, c);
                }
                c = new GridBagConstraints();
                c.insets = insets;
                c.anchor = 17;
                c.gridx = 0;
                c.gridy = line;
                this.contents.add((Component)new JLabel(GitBundle.getString("ssh.keyboard.interactive.username")), c);
                c = new GridBagConstraints();
                c.insets = insets;
                c.gridx = 1;
                c.gridy = line++;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.fill = 2;
                c.anchor = 17;
                this.contents.add((Component)new JLabel(this.myUserName), c);
                for (int i = 0; i < this.myNumPrompts; ++i) {
                    c = new GridBagConstraints();
                    c.insets = insets;
                    c.anchor = 17;
                    c.gridx = 0;
                    c.gridy = line;
                    JLabel promptLabel = new JLabel(this.myPrompt.get(i));
                    this.contents.add((Component)promptLabel, c);
                    c = new GridBagConstraints();
                    c.insets = insets;
                    c.gridx = 1;
                    c.gridy = line;
                    c.gridwidth = 1;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 17;
                    this.inputs[i] = this.myEcho.get(i) != false ? new JTextField(32) : new JPasswordField(32);
                    this.contents.add((Component)this.inputs[i], c);
                    ++line;
                }
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = line;
                c.gridwidth = 1;
                c.weighty = 1.0;
                c.fill = 3;
                c.anchor = 10;
                this.contents.add((Component)new JPanel(), c);
            }
            return this.contents;
        }

        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        public Vector<String> getResults() {
            Vector<String> rc = new Vector<String>(this.myNumPrompts);
            for (int i = 0; i < this.myNumPrompts; ++i) {
                rc.add(this.inputs[i].getText());
            }
            return rc;
        }

        public JComponent getPreferredFocusedComponent() {
            if (this.inputs.length > 0) {
                return this.inputs[0];
            }
            return super.getPreferredFocusedComponent();
        }
    }
}

