/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.configuration.TestNGRunnableState;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.xml.Parser;

public class TestNGConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements RunJavaConfiguration,
RefactoringListenerProvider {
    protected TestData data;
    protected transient Project project;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    public static final String DEFAULT_PACKAGE_NAME = ExecutionBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);
    public static final String DEFAULT_PACKAGE_CONFIGURATION_NAME = ExecutionBundle.message((String)"default.package.configuration.name", (Object[])new Object[0]);
    private final RefactoringListeners.Accessor<PsiPackage> myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

        public void setName(String qualifiedName) {
            boolean generatedName = TestNGConfiguration.this.isGeneratedName();
            TestNGConfiguration.this.data.PACKAGE_NAME = qualifiedName;
            if (generatedName) {
                TestNGConfiguration.this.setGeneratedName();
            }
        }

        @Nullable
        public PsiPackage getPsiElement() {
            String qualifiedName = TestNGConfiguration.this.data.getPackageName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)TestNGConfiguration.this.getProject()).findPackage(qualifiedName) : null;
        }

        public void setPsiElement(PsiPackage psiPackage) {
            this.setName(psiPackage.getQualifiedName());
        }
    };
    private final RefactoringListeners.Accessor<PsiClass> myClass = new RefactoringListeners.Accessor<PsiClass>(){

        public void setName(String qualifiedName) {
            boolean generatedName = TestNGConfiguration.this.isGeneratedName();
            TestNGConfiguration.this.data.MAIN_CLASS_NAME = qualifiedName;
            if (generatedName) {
                TestNGConfiguration.this.setGeneratedName();
            }
        }

        @Nullable
        public PsiClass getPsiElement() {
            String qualifiedName = TestNGConfiguration.this.data.getMainClassName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)TestNGConfiguration.this.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)TestNGConfiguration.this.project)) : null;
        }

        public void setPsiElement(PsiClass psiClass) {
            this.setName(psiClass.getQualifiedName());
        }
    };

    public TestNGConfiguration(String s, Project project, ConfigurationFactory factory) {
        this(s, project, new TestData(), factory);
    }

    private TestNGConfiguration(String s, Project project, TestData data, ConfigurationFactory factory) {
        super(s, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.data = data;
        this.project = project;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGConfiguration.getState must not be null");
        }
        return new TestNGRunnableState(env, this);
    }

    public TestData getPersistantData() {
        return this.data;
    }

    protected ModuleBasedConfiguration createInstance() {
        try {
            return new TestNGConfiguration(this.getName(), this.getProject(), (TestData)this.data.clone(), TestNGConfigurationType.getInstance().getConfigurationFactories()[0]);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.data.getMainClassName());
    }

    public boolean isGeneratedName() {
        return this.data.isGeneratedName(this.getName(), (JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public String suggestedName() {
        if (TestType.CLASS.getType().equals(this.data.TEST_OBJECT)) {
            String shortName = JavaExecutionUtil.getShortClassName((String)this.data.MAIN_CLASS_NAME);
            return ExecutionUtil.shortenName((String)shortName, (int)0);
        }
        if (TestType.PACKAGE.getType().equals(this.data.TEST_OBJECT)) {
            String s = this.getName();
            if (!this.isGeneratedName()) {
                return '\"' + s + '\"';
            }
            if (this.data.getPackageName().trim().length() > 0) {
                return "Tests in \"" + this.data.getPackageName() + '\"';
            }
            return "All Tests";
        }
        if (TestType.METHOD.getType().equals(this.data.TEST_OBJECT)) {
            return this.data.getMethodName() + "()";
        }
        if (TestType.SUITE.getType().equals(this.data.TEST_OBJECT)) {
            return this.data.getSuiteName();
        }
        return this.data.getGroupName();
    }

    public void setProperty(int type, String value) {
        this.data.setProperty(type, value, this.project);
    }

    public String getProperty(int type) {
        return this.data.getProperty(type, this.project);
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String ALTERNATIVE_JRE_PATH) {
        this.ALTERNATIVE_JRE_PATH = ALTERNATIVE_JRE_PATH;
    }

    public String getRunClass() {
        return !this.data.TEST_OBJECT.equals(TestType.CLASS.getType()) && !this.data.TEST_OBJECT.equals(TestType.METHOD.getType()) ? null : this.data.getMainClassName();
    }

    public String getPackage() {
        return !this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType()) ? null : this.data.getPackageName();
    }

    public void setClassConfiguration(PsiClass psiclass) {
        this.setModule(this.data.setMainClass(psiclass));
        this.data.TEST_OBJECT = TestType.CLASS.getType();
        this.setGeneratedName();
    }

    public void setPackageConfiguration(Module module, PsiPackage pkg) {
        this.data.setPackage(pkg);
        this.setModule(module);
        this.data.TEST_OBJECT = TestType.PACKAGE.getType();
        this.setGeneratedName();
    }

    public void setMethodConfiguration(Location<PsiMethod> location) {
        this.setModule(this.data.setTestMethod(location));
        this.setGeneratedName();
    }

    public void setGeneratedName() {
        this.setName(this.getGeneratedName());
    }

    public String getGeneratedName() {
        return this.data.getGeneratedName((JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new TestNGConfigurationEditor(this.getProject()));
        RunConfigurationExtension.appendEditors((ModuleBasedConfiguration)this, (SettingsEditorGroup)group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.data.TEST_OBJECT.equals(TestType.CLASS.getType()) || this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
            SourceScope scope = this.data.getScope().getSourceScope((ModuleBasedConfiguration)this);
            if (scope == null) {
                throw new RuntimeConfigurationException("Invalid scope specified");
            }
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.project).findClass(this.data.getMainClassName(), scope.getGlobalSearchScope());
            if (psiClass == null) {
                throw new RuntimeConfigurationException("Class '" + this.data.getMainClassName() + "' not found");
            }
            if (this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
                PsiMethod[] methods = psiClass.findMethodsByName(this.data.getMethodName(), true);
                if (methods.length == 0) {
                    throw new RuntimeConfigurationException("Method '" + this.data.getMethodName() + "' not found");
                }
                for (PsiMethod method : methods) {
                    if (method.hasModifierProperty("public")) continue;
                    throw new RuntimeConfigurationException("Non public method '" + this.data.getMethodName() + "'specified");
                }
            }
        } else if (this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.project).findPackage(this.data.getPackageName());
            if (psiPackage == null) {
                throw new RuntimeConfigurationException("Package '" + this.data.getMainClassName() + "' not found");
            }
        } else if (this.data.TEST_OBJECT.equals(TestType.SUITE.getType())) {
            try {
                FileInputStream in = new FileInputStream(this.data.getSuiteName());
                try {
                    new Parser((InputStream)in).parse();
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeConfigurationException("Unable to parse '" + this.data.getSuiteName() + "' specified");
            }
        }
        RunConfigurationExtension.checkConfigurationIsValid((ModuleBasedConfiguration)this);
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        RunConfigurationExtension.readSettings((ModuleBasedConfiguration)this, (Element)element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistantData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistantData().getEnvs());
        Map<String, String> properties = this.getPersistantData().TEST_PROPERTIES;
        properties.clear();
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null) {
            List children = propertiesElement.getChildren("property");
            for (Element property : children) {
                properties.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        List<String> listeners = this.getPersistantData().TEST_LISTENERS;
        listeners.clear();
        Element listenersElement = element.getChild("listeners");
        if (listenersElement != null) {
            List children = listenersElement.getChildren("listener");
            for (Element listenerClassName : children) {
                listeners.add(listenerClassName.getAttributeValue("class"));
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        RunConfigurationExtension.writeSettings((ModuleBasedConfiguration)this, (Element)element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.writeExternal((Object)this.getPersistantData(), (Element)element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getPersistantData().getEnvs());
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement == null) {
            propertiesElement = new Element("properties");
            element.addContent(propertiesElement);
        }
        Map<String, String> properties = this.getPersistantData().TEST_PROPERTIES;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Element property = new Element("property");
            property.setAttribute("name", entry.getKey());
            property.setAttribute("value", entry.getValue());
            propertiesElement.addContent(property);
        }
        Element listenersElement = element.getChild("listeners");
        if (listenersElement == null) {
            listenersElement = new Element("listeners");
            element.addContent(listenersElement);
        }
        List<String> listeners = this.getPersistantData().TEST_LISTENERS;
        for (String listener : listeners) {
            Element listenerElement = new Element("listener");
            listenerElement.setAttribute("class", listener);
            listenersElement.addContent(listenerElement);
        }
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
            if (!(element instanceof PsiPackage)) {
                return null;
            }
            return RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), this.myPackage);
        }
        if (this.data.TEST_OBJECT.equals(TestType.CLASS.getType())) {
            if (!(element instanceof PsiClass)) {
                return null;
            }
            return RefactoringListeners.getClassOrPackageListener((PsiElement)element, this.myClass);
        }
        if (this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
            if (!(element instanceof PsiMethod)) {
                return RefactoringListeners.getClassOrPackageListener((PsiElement)element, this.myClass);
            }
            PsiMethod method = (PsiMethod)element;
            if (!method.getName().equals(this.data.getMethodName())) {
                return null;
            }
            if (!method.getContainingClass().equals(this.myClass.getPsiElement())) {
                return null;
            }
            return new RefactoringElementListener(){

                public void elementMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGConfiguration$3.elementMoved must not be null");
                    }
                    this.setMethod((PsiMethod)newElement);
                }

                public void elementRenamed(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGConfiguration$3.elementRenamed must not be null");
                    }
                    this.setMethod((PsiMethod)newElement);
                }

                private void setMethod(PsiMethod psiMethod) {
                    boolean generatedName = TestNGConfiguration.this.isGeneratedName();
                    TestNGConfiguration.this.data.setTestMethod((Location<PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod));
                    if (generatedName) {
                        TestNGConfiguration.this.setGeneratedName();
                    }
                }
            };
        }
        return null;
    }
}

