/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.maddyhome.idea.copyright.CopyrightProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class ExternalOptionHelper {
    private static final Logger logger = Logger.getInstance((String)ExternalOptionHelper.class.getName());

    @Nullable
    public static List<CopyrightProfile> loadOptions(File file) {
        try {
            ArrayList<CopyrightProfile> profiles = new ArrayList<CopyrightProfile>();
            Document doc = JDOMUtil.loadDocument((File)file);
            Element root = doc.getRootElement();
            if (root.getName().equals("component")) {
                Element copyrightElement = root.getChild("copyright");
                if (copyrightElement != null) {
                    ExternalOptionHelper.extractNewNoticeAndKeyword(copyrightElement, profiles);
                }
            } else {
                List list = root.getChildren("component");
                for (Object element : list) {
                    Element component = (Element)element;
                    String name = component.getAttributeValue("name");
                    if (name.equals("CopyrightManager")) {
                        for (Object o : component.getChildren("copyright")) {
                            ExternalOptionHelper.extractNewNoticeAndKeyword((Element)o, profiles);
                        }
                        continue;
                    }
                    if (!name.equals("copyright")) continue;
                    ExternalOptionHelper.extractNoticeAndKeyword(component, profiles);
                }
            }
            return profiles.isEmpty() ? null : profiles;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static void extractNoticeAndKeyword(Element valueElement, List<CopyrightProfile> profiles) {
        CopyrightProfile profile = new CopyrightProfile();
        boolean extract = false;
        for (Object l : valueElement.getChildren("LanguageOptions")) {
            if (!((Element)l).getAttributeValue("name").equals("__TEMPLATE__")) continue;
            for (Object o1 : ((Element)l).getChildren("option")) {
                extract |= ExternalOptionHelper.extract(profile, (Element)o1);
            }
        }
        if (extract) {
            profiles.add(profile);
        }
    }

    public static void extractNewNoticeAndKeyword(Element valueElement, List<CopyrightProfile> profiles) {
        CopyrightProfile profile = new CopyrightProfile();
        boolean extract = false;
        for (Object l : valueElement.getChildren("option")) {
            extract |= ExternalOptionHelper.extract(profile, (Element)l);
        }
        if (extract) {
            profiles.add(profile);
        }
    }

    private static boolean extract(CopyrightProfile profile, Element el) {
        if (el.getAttributeValue("name").equals("notice")) {
            profile.setNotice(el.getAttributeValue("value"));
            return true;
        }
        if (el.getAttributeValue("name").equals("keyword")) {
            profile.setKeyword(el.getAttributeValue("value"));
        } else if (el.getAttributeValue("name").equals("myName")) {
            profile.setName(el.getAttributeValue("value"));
        }
        return false;
    }

    private ExternalOptionHelper() {
    }
}

