/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.NormalizeDeclarationFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MultipleTypedDeclarationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.typed.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MultipleTypedDeclarationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("VariablesOfDifferentTypesInDeclaration" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MultipleTypedDeclarationInspection.getID must not return null");
        }
        return "VariablesOfDifferentTypesInDeclaration";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.typed.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MultipleTypedDeclarationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultiplyTypedDeclarationVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NormalizeDeclarationFix();
    }

    private static class MultiplyTypedDeclarationVisitor
    extends BaseInspectionVisitor {
        private MultiplyTypedDeclarationVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            super.visitDeclarationStatement(statement);
            PsiElement[] elements = statement.getDeclaredElements();
            if (elements.length > 1) {
                PsiLocalVariable var;
                int i;
                PsiType baseType = ((PsiVariable)elements[0]).getType();
                boolean hasMultipleTypes = false;
                for (i = 1; i < elements.length; ++i) {
                    var = (PsiLocalVariable)elements[i];
                    PsiType variableType = var.getType();
                    if (variableType.equals(baseType)) continue;
                    hasMultipleTypes = true;
                }
                if (hasMultipleTypes) {
                    for (i = 1; i < elements.length; ++i) {
                        var = (PsiLocalVariable)elements[i];
                        this.registerVariableError((PsiVariable)var, new Object[0]);
                    }
                }
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MultipleTypedDeclarationInspection$MultiplyTypedDeclarationVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!MultiplyTypedDeclarationVisitor.childrenContainTypeElement((PsiElement)field)) {
                return;
            }
            List<PsiField> fields = MultiplyTypedDeclarationVisitor.getSiblingFields(field);
            if (fields.size() > 1) {
                int i;
                PsiField firstField = fields.get(0);
                PsiType baseType = firstField.getType();
                boolean hasMultipleTypes = false;
                for (i = 1; i < fields.size(); ++i) {
                    PsiField variable = fields.get(i);
                    PsiType variableType = variable.getType();
                    if (variableType.equals(baseType)) continue;
                    hasMultipleTypes = true;
                }
                if (hasMultipleTypes) {
                    for (i = 1; i < fields.size(); ++i) {
                        PsiField var = fields.get(i);
                        this.registerVariableError((PsiVariable)var, new Object[0]);
                    }
                }
            }
        }

        public static List<PsiField> getSiblingFields(PsiField field) {
            ArrayList<PsiField> out = new ArrayList<PsiField>(5);
            out.add(field);
            PsiField nextField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, PsiField.class);
            if (nextField != null) {
                PsiTypeElement nextTypeElement = nextField.getTypeElement();
                while (nextTypeElement != null && nextTypeElement.equals(field.getTypeElement())) {
                    out.add(nextField);
                    nextField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextField, PsiField.class);
                    if (nextField == null) break;
                    nextTypeElement = nextField.getTypeElement();
                }
            }
            return out;
        }

        public static boolean childrenContainTypeElement(PsiElement field) {
            PsiElement[] children;
            for (PsiElement aChildren : children = field.getChildren()) {
                if (!(aChildren instanceof PsiTypeElement)) continue;
                return true;
            }
            return false;
        }
    }
}

