/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CastThatLosesPrecisionInspection
extends BaseInspection {
    private static final Map<PsiType, Integer> typePrecisions = new HashMap<PsiType, Integer>(7);
    public boolean ignoreIntegerCharCasts = false;

    @NotNull
    public String getID() {
        if ("NumericCastThatLosesPrecision" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CastThatLosesPrecisionInspection.getID must not return null");
        }
        return "NumericCastThatLosesPrecision";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.that.loses.precision.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CastThatLosesPrecisionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType operandType = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("cast.that.loses.precision.problem.descriptor", operandType.getPresentableText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CastThatLosesPrecisionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cast.that.loses.precision.option", new Object[0]), (InspectionProfileEntry)this, "ignoreIntegerCharCasts");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastThatLosesPrecisionVisitor();
    }

    static {
        typePrecisions.put(PsiType.BYTE, 1);
        typePrecisions.put(PsiType.CHAR, 2);
        typePrecisions.put(PsiType.SHORT, 2);
        typePrecisions.put(PsiType.INT, 3);
        typePrecisions.put(PsiType.LONG, 4);
        typePrecisions.put(PsiType.FLOAT, 5);
        typePrecisions.put(PsiType.DOUBLE, 6);
    }

    private class CastThatLosesPrecisionVisitor
    extends BaseInspectionVisitor {
        private CastThatLosesPrecisionVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            Number number;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor.visitTypeCastExpression must not be null");
            }
            PsiType castType = expression.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (!ClassUtils.isPrimitiveNumericType(operandType)) {
                return;
            }
            if (this.hasLowerPrecision(operandType, castType)) {
                return;
            }
            if (CastThatLosesPrecisionInspection.this.ignoreIntegerCharCasts && PsiType.INT.equals(operandType) && PsiType.CHAR.equals(castType)) {
                return;
            }
            Object result = ExpressionUtils.computeConstantExpression(operand);
            if (result instanceof Character) {
                result = (int)((Character)result).charValue();
            }
            if (result instanceof Number && this.valueIsContainableInType(number = (Number)result, castType)) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, operandType);
        }

        private boolean hasLowerPrecision(PsiType operandType, PsiType castType) {
            Integer operandPrecision = (Integer)typePrecisions.get(operandType);
            Integer castPrecision = (Integer)typePrecisions.get(castType);
            return operandPrecision <= castPrecision;
        }

        private boolean valueIsContainableInType(Number value, PsiType type) {
            long longValue = value.longValue();
            double doubleValue = value.doubleValue();
            if (PsiType.BYTE.equals(type)) {
                return longValue >= -128L && longValue <= 127L && doubleValue >= -128.0 && doubleValue <= 127.0;
            }
            if (PsiType.CHAR.equals(type)) {
                return longValue >= 0L && longValue <= 65535L && doubleValue >= 0.0 && doubleValue <= 65535.0;
            }
            if (PsiType.SHORT.equals(type)) {
                return longValue >= -32768L && longValue <= 32767L && doubleValue >= -32768.0 && doubleValue <= 32767.0;
            }
            if (PsiType.INT.equals(type)) {
                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9;
            }
            if (PsiType.LONG.equals(type)) {
                return longValue >= Long.MIN_VALUE && longValue <= Long.MAX_VALUE && doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18;
            }
            if (PsiType.FLOAT.equals(type)) {
                return doubleValue == (double)value.floatValue();
            }
            return PsiType.DOUBLE.equals(type);
        }
    }
}

