/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OverloadedMethodsWithSameNumberOfParametersInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedMethodsWithSameNumberOfParametersVisitor();
    }

    private static class OverloadedMethodsWithSameNumberOfParametersVisitor
    extends BaseInspectionVisitor {
        private OverloadedMethodsWithSameNumberOfParametersVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection$OverloadedMethodsWithSameNumberOfParametersVisitor.visitMethod must not be null");
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String methodName = method.getName();
            PsiMethod[] sameNameMethods = aClass.findMethodsByName(methodName, false);
            int parameterCount = OverloadedMethodsWithSameNumberOfParametersVisitor.calculateParamCount(method);
            for (PsiMethod sameNameMethod : sameNameMethods) {
                int testParameterCount;
                if (sameNameMethod.equals(method) || parameterCount != (testParameterCount = OverloadedMethodsWithSameNumberOfParametersVisitor.calculateParamCount(sameNameMethod))) continue;
                this.registerMethodError(method, new Object[0]);
            }
        }

        private static int calculateParamCount(PsiMethod method) {
            PsiParameterList parameterList = method.getParameterList();
            return parameterList.getParametersCount();
        }
    }
}

