/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SuppressionAnnotationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/SuppressionAnnotationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/SuppressionAnnotationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuppressionAnnotationVisitor();
    }

    private static class SuppressionAnnotationVisitor
    extends BaseInspectionVisitor {
        private SuppressionAnnotationVisitor() {
        }

        public void visitComment(PsiComment comment) {
            super.visitComment(comment);
            String commentText = comment.getText();
            IElementType tokenType = comment.getTokenType();
            if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT) && !tokenType.equals(JavaTokenType.C_STYLE_COMMENT)) {
                return;
            }
            String strippedComment = commentText.substring(2).trim();
            if (strippedComment.startsWith("noinspection")) {
                this.registerError((PsiElement)comment, new Object[0]);
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null) {
                return;
            }
            String text = reference.getText();
            if ("SuppressWarnings".equals(text) || "java.lang.SuppressWarnings".equals(text)) {
                this.registerError((PsiElement)annotation, new Object[0]);
            }
        }
    }
}

