/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodCallInLoopConditionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/MethodCallInLoopConditionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/MethodCallInLoopConditionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCallInLoopConditionVisitor();
    }

    private static class MethodCallInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private MethodCallInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$MethodCallInLoopConditionVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$MethodCallInLoopConditionVisitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$MethodCallInLoopConditionVisitor.visitDoWhileStatement must not be null");
            }
            super.visitDoWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        private void checkForMethodCalls(PsiExpression condition) {
            JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$MethodCallInLoopConditionVisitor$1.visitMethodCallExpression must not be null");
                    }
                    super.visitMethodCallExpression(expression);
                    MethodCallInLoopConditionVisitor.this.registerMethodCallError(expression, new Object[0]);
                }
            };
            condition.accept((PsiElementVisitor)visitor);
        }
    }
}

