/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ConnectionResourceInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConnectionOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/ConnectionResourceInspection.getID must not return null");
        }
        return "ConnectionOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("connection.opened.not.safely.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/ConnectionResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/ConnectionResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RecordStoreResourceVisitor();
    }

    private static class CloseVisitor
    extends JavaRecursiveElementVisitor {
        private boolean containsClose = false;
        private final PsiVariable objectToClose;

        private CloseVisitor(PsiVariable objectToClose) {
            this.objectToClose = objectToClose;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/ConnectionResourceInspection$CloseVisitor.visitElement must not be null");
            }
            if (this.containsClose) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/ConnectionResourceInspection$CloseVisitor.visitMethodCallExpression must not be null");
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"close".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.objectToClose)) {
                this.containsClose = true;
            }
        }

        public boolean containsStreamClose() {
            return this.containsClose;
        }
    }

    private static class RecordStoreResourceVisitor
    extends BaseInspectionVisitor {
        private RecordStoreResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiAssignmentExpression assignment;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/ConnectionResourceInspection$RecordStoreResourceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!RecordStoreResourceVisitor.isConnectionFactoryMethod(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiAssignmentExpression)) {
                if (!(parent instanceof PsiTypeCastExpression)) {
                    PsiType type = expression.getType();
                    if (type != null) {
                        this.registerError((PsiElement)expression, type);
                    }
                    return;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiAssignmentExpression)) {
                    PsiType type = expression.getType();
                    if (type != null) {
                        this.registerError((PsiElement)expression, type);
                    }
                    return;
                }
                assignment = (PsiAssignmentExpression)grandParent;
            } else {
                assignment = (PsiAssignmentExpression)parent;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null || !(referent instanceof PsiVariable)) {
                return;
            }
            PsiVariable boundVariable = (PsiVariable)referent;
            PsiMethodCallExpression currentContext = expression;
            while (true) {
                PsiTryStatement tryStatement;
                if ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentContext, PsiTryStatement.class)) == null) {
                    PsiType type = expression.getType();
                    if (type != null) {
                        this.registerError((PsiElement)expression, type);
                    }
                    return;
                }
                if (RecordStoreResourceVisitor.resourceIsOpenedInTryAndClosedInFinally(tryStatement, (PsiExpression)expression, boundVariable)) {
                    return;
                }
                currentContext = tryStatement;
            }
        }

        private static boolean resourceIsOpenedInTryAndClosedInFinally(PsiTryStatement tryStatement, PsiExpression lhs, PsiVariable boundVariable) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)lhs, (boolean)true)) {
                return false;
            }
            return RecordStoreResourceVisitor.containsResourceClose(finallyBlock, boundVariable);
        }

        private static boolean containsResourceClose(PsiCodeBlock finallyBlock, PsiVariable boundVariable) {
            CloseVisitor visitor = new CloseVisitor(boundVariable);
            finallyBlock.accept((PsiElementVisitor)visitor);
            return visitor.containsStreamClose();
        }

        private static boolean isConnectionFactoryMethod(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/ConnectionResourceInspection$RecordStoreResourceVisitor.isConnectionFactoryMethod must not be null");
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"open".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            String microeditionConnector = "javax.microedition.io.Connector";
            return "javax.microedition.io.Connector".equals(className);
        }
    }
}

