/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveAnonymousToInnerClassFix;
import com.siyeh.ig.performance.InnerClassReferenceVisitor;
import org.jetbrains.annotations.NotNull;

public class AnonymousInnerClassMayBeStaticInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/AnonymousInnerClassMayBeStaticInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/AnonymousInnerClassMayBeStaticInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveAnonymousToInnerClassFix(InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.quickfix", new Object[0]));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousInnerClassMayBeStaticVisitor();
    }

    private static class AnonymousInnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private AnonymousInnerClassMayBeStaticVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/AnonymousInnerClassMayBeStaticInspection$AnonymousInnerClassMayBeStaticVisitor.visitClass must not be null");
            }
            if (!(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            PsiMember containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMember.class);
            if (containingMember == null || containingMember.hasModifierProperty("static")) {
                return;
            }
            PsiAnonymousClass anAnonymousClass = (PsiAnonymousClass)aClass;
            InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor((PsiClass)anAnonymousClass);
            anAnonymousClass.accept((PsiElementVisitor)visitor);
            if (!visitor.canInnerClassBeStatic()) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

