/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractMethodFix;
import com.siyeh.ig.ui.FormattedTextFieldMacFix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlyComplexBooleanExpressionInspection
extends BaseInspection {
    private static final Set<String> s_booleanOperators = new HashSet<String>(5);
    private JFormattedTextField m_termLimitTextField;
    private JCheckBox m_ignoreConjunctionsDisjunctionsCheckBox;
    private JPanel m_contentPanel;
    public int m_limit = 3;
    public boolean m_ignorePureConjunctionsDisjunctions = true;

    public OverlyComplexBooleanExpressionInspection() {
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.complex.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overly.complex.boolean.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        final ButtonModel pureModel = this.m_ignoreConjunctionsDisjunctionsCheckBox.getModel();
        pureModel.setSelected(this.m_ignorePureConjunctionsDisjunctions);
        pureModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OverlyComplexBooleanExpressionInspection.this.m_ignorePureConjunctionsDisjunctions = pureModel.isSelected();
            }
        });
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        this.m_termLimitTextField.setValue(this.m_limit);
        this.m_termLimitTextField.setColumns(4);
        FormattedTextFieldMacFix.apply(this.m_termLimitTextField);
        Document document = this.m_termLimitTextField.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            private void textChanged() {
                try {
                    OverlyComplexBooleanExpressionInspection.this.m_termLimitTextField.commitEdit();
                    Number number = (Number)OverlyComplexBooleanExpressionInspection.this.m_termLimitTextField.getValue();
                    OverlyComplexBooleanExpressionInspection.this.m_limit = number.intValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        return this.m_contentPanel;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtractMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooManyBranchesVisitor();
    }

    static {
        s_booleanOperators.add("&&");
        s_booleanOperators.add("||");
        s_booleanOperators.add("^");
        s_booleanOperators.add("&");
        s_booleanOperators.add("|");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JFormattedTextField jFormattedTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.m_contentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.m_ignoreConjunctionsDisjunctionsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("ovetly.complex.boolean.expression.ignore.pure.conjunctions.and.disjunctions.option"));
        jCheckBox.setSelected(false);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.m_termLimitTextField = jFormattedTextField = new JFormattedTextField();
        jPanel.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(20, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("overly.complex.boolean.expression.overly.option"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.m_contentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class SwitchStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooManyBranchesVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspection$SwitchStatementWithTooManyBranchesVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspection$SwitchStatementWithTooManyBranchesVisitor.visitPrefixExpression must not be null");
            }
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspection$SwitchStatementWithTooManyBranchesVisitor.visitParenthesizedExpression must not be null");
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            if (!this.isBoolean(expression)) {
                return;
            }
            if (this.isParentBoolean(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= OverlyComplexBooleanExpressionInspection.this.m_limit) {
                return;
            }
            if (OverlyComplexBooleanExpressionInspection.this.m_ignorePureConjunctionsDisjunctions && expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiJavaToken sign = binaryExpression.getOperationSign();
                String signText = sign.getText();
                if (s_booleanOperators.contains(signText) && this.isPureConjunctionDisJunction(expression, signText)) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private int countTerms(PsiExpression expression) {
            if (!this.isBoolean(expression)) {
                return 1;
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiExpression operand = prefixExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentBoolean(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpression)) {
                return false;
            }
            return this.isBoolean((PsiExpression)parent);
        }

        private boolean isBoolean(PsiExpression expression) {
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiJavaToken sign = binaryExpression.getOperationSign();
                String signText = sign.getText();
                return s_booleanOperators.contains(signText);
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiJavaToken sign = prefixExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                return tokenType.equals(JavaTokenType.EXCL);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.isBoolean(contents);
            }
            return false;
        }

        private boolean isPureConjunctionDisJunction(@Nullable PsiExpression expression, @NotNull String operator) {
            if (operator == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspection$SwitchStatementWithTooManyBranchesVisitor.isPureConjunctionDisJunction must not be null");
            }
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiPrefixExpression || expression instanceof PsiParenthesizedExpression) {
                return false;
            }
            if (!(expression instanceof PsiBinaryExpression)) {
                return true;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String signText = sign.getText();
            if (s_booleanOperators.contains(signText) && !operator.equals(signText)) {
                return false;
            }
            PsiExpression lOperand = binaryExpression.getLOperand();
            PsiExpression rOperand = binaryExpression.getROperand();
            return this.isPureConjunctionDisJunction(lOperand, operator) && this.isPureConjunctionDisJunction(rOperand, operator);
        }
    }
}

