/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallthruInSwitchStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("fallthru.in.switch.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("fallthrough" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection.getID must not return null");
        }
        return "fallthrough";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("fallthru.in.switch.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new FallthruInSwitchStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FallthroughInSwitchStatementVisitor();
    }

    private static class FallthroughInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private FallthroughInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            PsiStatement[] statements;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection$FallthroughInSwitchStatementVisitor.visitSwitchStatement must not be null");
            }
            super.visitSwitchStatement(statement);
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return;
            }
            boolean switchLabelValid = true;
            for (PsiStatement child : statements = body.getStatements()) {
                if (child instanceof PsiSwitchLabelStatement) {
                    if (!switchLabelValid) {
                        this.registerError((PsiElement)child, new Object[0]);
                    }
                    switchLabelValid = true;
                    continue;
                }
                switchLabelValid = !ControlFlowUtils.statementMayCompleteNormally(child);
            }
        }
    }

    private static class FallthruInSwitchStatementFix
    extends InspectionGadgetsFix {
        private FallthruInSwitchStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("fallthru.in.switch.statement.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection$FallthruInSwitchStatementFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)descriptor.getPsiElement();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiStatement breakStatement = factory.createStatementFromText("break;", (PsiElement)labelStatement);
            PsiElement parent = labelStatement.getParent();
            parent.addBefore((PsiElement)breakStatement, (PsiElement)labelStatement);
        }
    }
}

