/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SuspiciousIndentAfterControlStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.indent.after.control.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/SuspiciousIndentAfterControlStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.indent.after.control.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/SuspiciousIndentAfterControlStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousIndentAfterControlStatementVisitor();
    }

    private static class SuspiciousIndentAfterControlStatementVisitor
    extends BaseInspectionVisitor {
        private SuspiciousIndentAfterControlStatementVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement nextStatement;
            super.visitIfStatement(statement);
            PsiStatement elseStatement = statement.getElseBranch();
            if (elseStatement instanceof PsiBlockStatement) {
                return;
            }
            if (elseStatement == null) {
                PsiStatement thenStatement = statement.getThenBranch();
                if (thenStatement instanceof PsiBlockStatement) {
                    return;
                }
                if (thenStatement != null && !SuspiciousIndentAfterControlStatementVisitor.isWhitespaceSuspicious((PsiStatement)statement, thenStatement)) {
                    return;
                }
            } else if (!SuspiciousIndentAfterControlStatementVisitor.isWhitespaceSuspicious((PsiStatement)statement, elseStatement)) {
                return;
            }
            if ((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class)) == null) {
                return;
            }
            this.registerStatementError(nextStatement, new Object[0]);
        }

        private void checkLoopStatement(PsiLoopStatement statement) {
            PsiStatement body = statement.getBody();
            if (body instanceof PsiBlockStatement || body == null) {
                return;
            }
            if (!SuspiciousIndentAfterControlStatementVisitor.isWhitespaceSuspicious((PsiStatement)statement, body)) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            if (nextStatement == null) {
                return;
            }
            this.registerStatementError(nextStatement, new Object[0]);
        }

        private static boolean isWhitespaceSuspicious(PsiStatement statement, PsiStatement body) {
            PsiStatement nextStatement;
            boolean lineBreakBeforeBody;
            PsiElement prevSibling = body.getPrevSibling();
            if (!(prevSibling instanceof PsiWhiteSpace)) {
                lineBreakBeforeBody = false;
                prevSibling = statement.getPrevSibling();
                if (!(prevSibling instanceof PsiWhiteSpace)) {
                    return false;
                }
            } else {
                String text = prevSibling.getText();
                int lineBreakIndex = SuspiciousIndentAfterControlStatementVisitor.getLineBreakIndex(text);
                if (lineBreakIndex < 0) {
                    lineBreakBeforeBody = false;
                    prevSibling = statement.getPrevSibling();
                    if (!(prevSibling instanceof PsiWhiteSpace)) {
                        return false;
                    }
                } else {
                    lineBreakBeforeBody = true;
                }
            }
            if ((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class)) == null) {
                return false;
            }
            String text = prevSibling.getText();
            int index = SuspiciousIndentAfterControlStatementVisitor.getLineBreakIndex(text);
            if (index < 0) {
                return false;
            }
            String indent = text.substring(index + 1);
            PsiElement nextSibling = nextStatement.getPrevSibling();
            if (!(nextSibling instanceof PsiWhiteSpace)) {
                return false;
            }
            String nextText = nextSibling.getText();
            int nextIndex = SuspiciousIndentAfterControlStatementVisitor.getLineBreakIndex(nextText);
            if (nextIndex < 0) {
                return false;
            }
            String nextIndent = nextText.substring(nextIndex + 1);
            if (lineBreakBeforeBody) {
                return indent.equals(nextIndent);
            }
            return !indent.equals(nextIndent);
        }

        private static int getLineBreakIndex(String text) {
            int newLineIndex1 = text.lastIndexOf(10);
            int carriageReturnIndex1 = text.lastIndexOf(13);
            return Math.max(newLineIndex1, carriageReturnIndex1);
        }
    }
}

