/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewStringBufferWithCharArgumentInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        if (!(argument instanceof PsiLiteralExpression)) {
            return null;
        }
        return new NewStringBufferWithCharArgumentFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferWithCharArgumentVisitor();
    }

    private static class StringBufferWithCharArgumentVisitor
    extends BaseInspectionVisitor {
        private StringBufferWithCharArgumentVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            if (!PsiType.CHAR.equals(type)) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (!ClassUtils.isSubclass(aClass, "java.lang.AbstractStringBuilder")) {
                return;
            }
            this.registerNewExpressionError(expression, argument);
        }
    }

    private static class NewStringBufferWithCharArgumentFix
    extends InspectionGadgetsFix {
        private NewStringBufferWithCharArgumentFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection$NewStringBufferWithCharArgumentFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiNewExpression newExpression = (PsiNewExpression)element.getParent();
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String text = argument.getText();
            String newArgument = '\"' + text.substring(1, text.length() - 1) + '\"';
            NewStringBufferWithCharArgumentFix.replaceExpression(argument, newArgument);
        }
    }
}

