/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import org.jetbrains.annotations.NotNull;

public class StaticVariableOfConcreteClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.of.concrete.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/StaticVariableOfConcreteClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.variable.of.concrete.class.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/StaticVariableOfConcreteClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableOfConcreteClassVisitor();
    }

    private static class StaticVariableOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private StaticVariableOfConcreteClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/StaticVariableOfConcreteClassInspection$StaticVariableOfConcreteClassVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiTypeElement typeElement = field.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement)) {
                return;
            }
            String variableName = field.getName();
            this.registerError((PsiElement)typeElement, variableName);
        }
    }
}

