/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SolveableAuthenticationException;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class SshPasswordAuthentication
implements SshAuthentication {
    private static final String PASSWORD_METHOD = "password";
    private static final String KEYBOARD_METHOD = "keyboard-interactive";
    private final String myLogin;
    private final SSHPasswordProvider myPasswordProvider;
    private final String myCvsRootAsString;

    public SshPasswordAuthentication(String login, SSHPasswordProvider passwordProvider, String cvsRootAsString) {
        this.myLogin = login;
        this.myPasswordProvider = passwordProvider;
        this.myCvsRootAsString = cvsRootAsString;
    }

    @Override
    public void authenticate(Connection connection) throws AuthenticationException, SolveableAuthenticationException {
        final String password = this.myPasswordProvider.getPasswordForCvsRoot(this.myCvsRootAsString);
        if (password == null) {
            throw new SolveableAuthenticationException("Authentication rejected.");
        }
        try {
            boolean wasAuthenticated;
            String[] methodsArr = connection.getRemainingAuthMethods(this.myLogin);
            if (methodsArr == null || methodsArr.length == 0) {
                return;
            }
            List<String> methods = Arrays.asList(methodsArr);
            if (methods.contains(PASSWORD_METHOD) && connection.authenticateWithPassword(this.myLogin, password)) {
                return;
            }
            if (methods.contains(KEYBOARD_METHOD) && (wasAuthenticated = connection.authenticateWithKeyboardInteractive(this.myLogin, new InteractiveCallback(){

                public String[] replyToChallenge(String s, String instruction, int numPrompts, String[] strings, boolean[] booleans) throws Exception {
                    Object[] result = new String[numPrompts];
                    if (numPrompts > 0) {
                        Arrays.fill(result, password);
                    }
                    return result;
                }
            }))) {
                return;
            }
            throw new SolveableAuthenticationException("Authentication rejected.");
        }
        catch (IOException e) {
            throw new SolveableAuthenticationException(e.getMessage(), e);
        }
    }
}

