/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenDefaultModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenUIModifiableModelsProvider;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenIcons;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectBuilder
extends ProjectImportBuilder<MavenProject> {
    private Parameters myParamaters;

    public String getName() {
        return ProjectBundle.message("maven.name", new Object[0]);
    }

    public Icon getIcon() {
        return MavenIcons.MAVEN_ICON;
    }

    public void cleanup() {
        this.myParamaters = null;
        super.cleanup();
    }

    public boolean isSuitableSdk(Sdk sdk) {
        return sdk.getSdkType() == JavaSdk.getInstance();
    }

    private Parameters getParameters() {
        if (this.myParamaters == null) {
            this.myParamaters = new Parameters();
        }
        return this.myParamaters;
    }

    public boolean validate(Project current, Project dest) {
        return true;
    }

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        MavenWorkspaceSettings settings = ((MavenWorkspaceSettingsComponent)((Object)project.getComponent(MavenWorkspaceSettingsComponent.class))).getState();
        settings.generalSettings = this.getGeneralSettings();
        settings.importingSettings = this.getImportingSettings();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        List<VirtualFile> files = this.getParameters().myMavenProjectTree.getRootProjectsFiles();
        manager.addManagedFilesWithProfiles(files, this.getSelectedProfiles());
        manager.waitForReadingCompletion();
        boolean isFromUI = model != null;
        return manager.importProjects(isFromUI ? new MavenUIModifiableModelsProvider(project, model, (ModulesConfigurator)modulesProvider, artifactModel) : new MavenDefaultModifiableModelsProvider(project));
    }

    public VirtualFile getRootDirectory() {
        return this.getImportRoot();
    }

    public boolean setRootDirectory(String root) throws ConfigurationException {
        this.getParameters().myFiles = null;
        this.getParameters().myProfiles.clear();
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().myImportRoot = FileFinder.refreshRecursively(root);
        if (this.getParameters().myImportRoot == null) {
            return false;
        }
        return this.runConfigurationProcess(ProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                indicator.setText(ProjectBundle.message("maven.locating.files", new Object[0]));
                MavenProjectBuilder.this.getParameters().myFiles = FileFinder.findPomFiles(MavenProjectBuilder.this.getImportRoot().getChildren(), MavenProjectBuilder.this.getImportingSettings().isLookForNested(), indicator.getIndicator(), new ArrayList<VirtualFile>());
                MavenProjectBuilder.this.collectProfiles(indicator);
                if (MavenProjectBuilder.this.getParameters().myProfiles.isEmpty()) {
                    MavenProjectBuilder.this.readMavenProjectTree(indicator);
                }
                indicator.setText("");
                indicator.setText2("");
            }
        });
    }

    private void collectProfiles(MavenProgressIndicator process) {
        process.setText(ProjectBundle.message("maven.searching.profiles", new Object[0]));
        LinkedHashSet<String> uniqueProfiles = new LinkedHashSet<String>();
        MavenProjectReader reader = new MavenProjectReader();
        MavenGeneralSettings generalSettings = this.getGeneralSettings();
        MavenProjectReaderProjectLocator locator = new MavenProjectReaderProjectLocator(){

            @Override
            public VirtualFile findProjectFile(MavenId coordinates) {
                return null;
            }
        };
        for (VirtualFile f : this.getParameters().myFiles) {
            MavenProject project = new MavenProject(f);
            process.setText2(ProjectBundle.message("maven.reading.pom", f.getPath()));
            project.read(generalSettings, Collections.EMPTY_LIST, reader, locator);
            uniqueProfiles.addAll(project.getProfilesIds());
        }
        this.getParameters().myProfiles = new ArrayList(uniqueProfiles);
    }

    public List<String> getProfiles() {
        return this.getParameters().myProfiles;
    }

    public List<String> getSelectedProfiles() {
        return this.getParameters().mySelectedProfiles;
    }

    public boolean setSelectedProfiles(List<String> profiles) {
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().mySelectedProfiles = profiles;
        return this.runConfigurationProcess(ProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText2("");
            }
        });
    }

    private boolean runConfigurationProcess(String message, MavenTask p) {
        try {
            MavenUtil.run(null, message, p);
        }
        catch (MavenProcessCanceledException e) {
            return false;
        }
        return true;
    }

    private void readMavenProjectTree(MavenProgressIndicator process) throws MavenProcessCanceledException {
        MavenProjectsTree tree = new MavenProjectsTree();
        tree.addManagedFilesWithProfiles(this.getParameters().myFiles, this.getParameters().mySelectedProfiles);
        tree.updateAll(false, this.getGeneralSettings(), process, null);
        this.getParameters().myMavenProjectTree = tree;
    }

    public List<MavenProject> getList() {
        return this.getParameters().myMavenProjectTree.getRootProjects();
    }

    public void setList(List<MavenProject> projects) {
    }

    public boolean isMarked(MavenProject element) {
        return true;
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenModulesConfigurator;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().myOpenModulesConfigurator = on;
    }

    public MavenGeneralSettings getGeneralSettings() {
        if (this.getParameters().myGeneralSettingsCache == null) {
            this.getParameters().myGeneralSettingsCache = this.getDirectProjectsSettings().generalSettings.clone();
        }
        return this.getParameters().myGeneralSettingsCache;
    }

    public MavenImportingSettings getImportingSettings() {
        if (this.getParameters().myImportingSettingsCache == null) {
            this.getParameters().myImportingSettingsCache = this.getDirectProjectsSettings().importingSettings.clone();
        }
        return this.getParameters().myImportingSettingsCache;
    }

    private MavenWorkspaceSettings getDirectProjectsSettings() {
        return ((MavenWorkspaceSettingsComponent)((Object)this.getProject().getComponent(MavenWorkspaceSettingsComponent.class))).getState();
    }

    private Project getProject() {
        return this.isUpdate() ? this.getProjectToUpdate() : ProjectManager.getInstance().getDefaultProject();
    }

    public void setFiles(List<VirtualFile> files) {
        this.getParameters().myFiles = files;
    }

    @Nullable
    public Project getProjectToUpdate() {
        if (this.getParameters().myProjectToUpdate == null) {
            this.getParameters().myProjectToUpdate = MavenProjectBuilder.getCurrentProject();
        }
        return this.getParameters().myProjectToUpdate;
    }

    @Nullable
    public VirtualFile getImportRoot() {
        if (this.getParameters().myImportRoot == null && this.isUpdate()) {
            Project project = this.getProjectToUpdate();
            assert (project != null);
            this.getParameters().myImportRoot = project.getBaseDir();
        }
        return this.getParameters().myImportRoot;
    }

    public String getSuggestedProjectName() {
        List<MavenProject> list = this.getParameters().myMavenProjectTree.getRootProjects();
        if (list.size() == 1) {
            return list.get(0).getMavenId().getArtifactId();
        }
        return null;
    }

    private static class Parameters {
        private Project myProjectToUpdate;
        private MavenGeneralSettings myGeneralSettingsCache;
        private MavenImportingSettings myImportingSettingsCache;
        private VirtualFile myImportRoot;
        private List<VirtualFile> myFiles;
        private List<String> myProfiles = new ArrayList<String>();
        private List<String> mySelectedProfiles = new ArrayList<String>();
        private MavenProjectsTree myMavenProjectTree;
        private boolean myOpenModulesConfigurator;

        private Parameters() {
        }
    }
}

