/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Resource;

public class MavenResource
implements Serializable {
    private String myDirectory;
    private boolean myFiltered;
    private String myTargetPath;
    private List<String> myIncludes;
    private List<String> myExcludes;

    protected MavenResource() {
    }

    public MavenResource(Resource resource) {
        this.myDirectory = resource.getDirectory();
        this.myFiltered = resource.isFiltering();
        this.myTargetPath = resource.getTargetPath();
        this.myIncludes = resource.getIncludes();
        this.myExcludes = resource.getExcludes();
        if (this.myIncludes == null) {
            this.myIncludes = Collections.EMPTY_LIST;
        }
        if (this.myExcludes == null) {
            this.myExcludes = Collections.EMPTY_LIST;
        }
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public String getTargetPath() {
        return this.myTargetPath;
    }

    public List<String> getIncludes() {
        return this.myIncludes;
    }

    public List<String> getExcludes() {
        return this.myExcludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenResource that = (MavenResource)o;
        if (this.myFiltered != that.myFiltered) {
            return false;
        }
        if (this.myDirectory != null ? !this.myDirectory.equals(that.myDirectory) : that.myDirectory != null) {
            return false;
        }
        if (this.myExcludes != null ? !((Object)this.myExcludes).equals(that.myExcludes) : that.myExcludes != null) {
            return false;
        }
        if (this.myIncludes != null ? !((Object)this.myIncludes).equals(that.myIncludes) : that.myIncludes != null) {
            return false;
        }
        return !(this.myTargetPath != null ? !this.myTargetPath.equals(that.myTargetPath) : that.myTargetPath != null);
    }

    public int hashCode() {
        int result = this.myDirectory != null ? this.myDirectory.hashCode() : 0;
        result = 31 * result + (this.myFiltered ? 1 : 0);
        result = 31 * result + (this.myTargetPath != null ? this.myTargetPath.hashCode() : 0);
        result = 31 * result + (this.myIncludes != null ? ((Object)this.myIncludes).hashCode() : 0);
        result = 31 * result + (this.myExcludes != null ? ((Object)this.myExcludes).hashCode() : 0);
        return result;
    }
}

